/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.cxf.jaxrs.model.CurlyBraceTokenizer;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URITemplate {
    public static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    public static final String LIMITED_REGEX_SUFFIX = "(/.*)?";
    public static final String FINAL_MATCH_GROUP = "FINAL_MATCH_GROUP";
    private static final String DEFAULT_PATH_VARIABLE_REGEX = "([^/]+?)";
    private static final String CHARACTERS_TO_ESCAPE = ".";
    private final String template;
    private final List<String> variables = new ArrayList<String>();
    private final List<String> customVariables = new ArrayList<String>();
    private final Pattern templateRegexPattern;
    private final String literals;
    private final List<UriChunk> uriChunks;

    public URITemplate(String theTemplate) {
        boolean endsWithSlash;
        this.template = theTemplate;
        StringBuilder literalChars = new StringBuilder();
        StringBuilder patternBuilder = new StringBuilder();
        CurlyBraceTokenizer tok = new CurlyBraceTokenizer(this.template);
        this.uriChunks = new ArrayList<UriChunk>();
        while (tok.hasNext()) {
            String templatePart = tok.next();
            UriChunk chunk = UriChunk.createUriChunk(templatePart);
            this.uriChunks.add(chunk);
            if (chunk instanceof Literal) {
                String substr = URITemplate.escapeCharacters(chunk.getValue());
                literalChars.append(substr);
                patternBuilder.append(substr);
                continue;
            }
            if (!(chunk instanceof Variable)) continue;
            Variable var = (Variable)chunk;
            this.variables.add(var.getName());
            if (var.getPattern() != null) {
                this.customVariables.add(var.getName());
                patternBuilder.append('(');
                patternBuilder.append(var.getPattern());
                patternBuilder.append(')');
                continue;
            }
            patternBuilder.append(DEFAULT_PATH_VARIABLE_REGEX);
        }
        this.literals = literalChars.toString();
        int endPos = patternBuilder.length() - 1;
        boolean bl = endPos >= 0 ? patternBuilder.charAt(endPos) == '/' : (endsWithSlash = false);
        if (endsWithSlash) {
            patternBuilder.deleteCharAt(endPos);
        }
        patternBuilder.append(LIMITED_REGEX_SUFFIX);
        this.templateRegexPattern = Pattern.compile(patternBuilder.toString());
    }

    public String getLiteralChars() {
        return this.literals;
    }

    public String getValue() {
        return this.template;
    }

    public List<String> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public List<String> getCustomVariables() {
        return Collections.unmodifiableList(this.customVariables);
    }

    private static String escapeCharacters(String expression) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            sb.append(URITemplate.isReservedCharacter(ch) ? "\\" + ch : Character.valueOf(ch));
        }
        return sb.toString();
    }

    private static boolean isReservedCharacter(char ch) {
        return CHARACTERS_TO_ESCAPE.indexOf(ch) != -1;
    }

    public boolean match(String uri, MultivaluedMap<String, String> templateVariableToValue) {
        if (uri == null) {
            return this.templateRegexPattern == null;
        }
        if (this.templateRegexPattern == null) {
            return false;
        }
        Matcher m = this.templateRegexPattern.matcher(uri);
        if (!m.matches()) {
            if (uri.contains(";")) {
                List<PathSegment> pList = JAXRSUtils.getPathSegments(this.template, false);
                List<PathSegment> uList = JAXRSUtils.getPathSegments(uri, false);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < uList.size(); ++i) {
                    sb.append('/');
                    if (pList.size() > i && pList.get(i).getPath().indexOf(123) == -1) {
                        sb.append(uList.get(i).getPath());
                        continue;
                    }
                    sb.append(HttpUtils.fromPathSegment(uList.get(i)));
                }
                uri = sb.toString();
                m = this.templateRegexPattern.matcher(uri);
                if (!m.matches()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        int i = 1;
        for (String name : this.variables) {
            String value = m.group(i++);
            templateVariableToValue.add((Object)name, (Object)value);
        }
        String finalGroup = m.group(i);
        templateVariableToValue.putSingle((Object)FINAL_MATCH_GROUP, (Object)(finalGroup == null ? "/" : finalGroup));
        return true;
    }

    public String substitute(List<String> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        Iterator<String> iter = values.iterator();
        StringBuffer sb = new StringBuffer();
        for (UriChunk chunk : this.uriChunks) {
            if (chunk instanceof Variable) {
                Variable var = (Variable)chunk;
                if (iter.hasNext()) {
                    String value = iter.next();
                    if (!var.matches(value)) {
                        throw new IllegalArgumentException("Value '" + value + "' does not match variable " + var.getName() + " with pattern " + var.getPattern());
                    }
                    sb.append(value);
                    continue;
                }
                sb.append(var);
                continue;
            }
            sb.append(chunk);
        }
        return sb.toString();
    }

    public String substitute(Map<String, ? extends Object> valuesMap) throws IllegalArgumentException {
        if (valuesMap == null) {
            throw new IllegalArgumentException("valuesMap is null");
        }
        StringBuffer sb = new StringBuffer();
        for (UriChunk chunk : this.uriChunks) {
            if (chunk instanceof Variable) {
                Variable var = (Variable)chunk;
                Object value = valuesMap.get(var.getName());
                if (value != null) {
                    String sval = value.toString();
                    if (!var.matches(sval)) {
                        throw new IllegalArgumentException("Value '" + sval + "' does not match variable " + var.getName() + " with pattern " + var.getPattern());
                    }
                    sb.append(value);
                    continue;
                }
                sb.append(var);
                continue;
            }
            sb.append(chunk);
        }
        return sb.toString();
    }

    public String encodeLiteralCharacters() {
        float encodedRatio = 1.5f;
        StringBuffer sb = new StringBuffer((int)(1.5f * (float)this.template.length()));
        for (UriChunk chunk : this.uriChunks) {
            String val = chunk.getValue();
            if (chunk instanceof Literal) {
                sb.append(HttpUtils.encodePartiallyEncoded(val, false));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public static URITemplate createTemplate(Path path) {
        return URITemplate.createTemplate(path == null ? null : path.value());
    }

    public static URITemplate createTemplate(String pathValue) {
        if (pathValue == null) {
            return new URITemplate("/");
        }
        if (!pathValue.startsWith("/")) {
            pathValue = "/" + pathValue;
        }
        return new URITemplate(pathValue);
    }

    public static int compareTemplates(URITemplate t1, URITemplate t2) {
        int gCustom2;
        int gCustom1;
        int result;
        int g2;
        String l2;
        String l1 = t1.getLiteralChars();
        if (!l1.equals(l2 = t2.getLiteralChars())) {
            return l1.length() < l2.length() ? 1 : -1;
        }
        int g1 = t1.getVariables().size();
        int n = g1 < (g2 = t2.getVariables().size()) ? 1 : (result = g1 > g2 ? -1 : 0);
        if (result == 0 && (gCustom1 = t1.getCustomVariables().size()) != (gCustom2 = t2.getCustomVariables().size())) {
            return gCustom1 < gCustom2 ? 1 : -1;
        }
        return result;
    }

    private static final class Variable
    extends UriChunk {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\w[-\\w\\.]*)(\\:(.+))?");
        private String name;
        private Pattern pattern;

        public Variable(String uriChunk) throws IllegalArgumentException, PatternSyntaxException {
            Matcher matcher;
            if (uriChunk == null || "".equals(uriChunk)) {
                throw new IllegalArgumentException("uriChunk is empty");
            }
            if (CurlyBraceTokenizer.insideBraces(uriChunk) && (matcher = VARIABLE_PATTERN.matcher(uriChunk = CurlyBraceTokenizer.stripBraces(uriChunk))).matches()) {
                this.name = matcher.group(1).trim();
                if (matcher.group(2) != null && matcher.group(3) != null) {
                    this.pattern = Pattern.compile(matcher.group(3).trim());
                }
                return;
            }
            throw new IllegalArgumentException("not a variable syntax");
        }

        public String getName() {
            return this.name;
        }

        public String getPattern() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        public boolean matches(String value) {
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(value).matches();
        }

        public String getValue() {
            if (this.pattern != null) {
                return "{" + this.name + ":" + this.pattern + "}";
            }
            return "{" + this.name + "}";
        }
    }

    private static final class Literal
    extends UriChunk {
        private String value;

        public Literal(String uriChunk) {
            if (uriChunk == null || "".equals(uriChunk)) {
                throw new IllegalArgumentException("uriChunk is empty");
            }
            this.value = uriChunk;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static abstract class UriChunk {
        private UriChunk() {
        }

        public static UriChunk createUriChunk(String uriChunk) {
            if (uriChunk == null || "".equals(uriChunk)) {
                throw new IllegalArgumentException("uriChunk is empty");
            }
            try {
                return new Variable(uriChunk);
            }
            catch (IllegalArgumentException e) {
                return new Literal(uriChunk);
            }
        }

        public abstract String getValue();

        public String toString() {
            return this.getValue();
        }
    }
}

