/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileRenameProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileNoOpProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericFileProcessStrategyFactory {
    private GenericFileProcessStrategyFactory() {
    }

    public static GenericFileProcessStrategy createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        Expression moveExpression = (Expression)params.get("move");
        Expression preMoveExpression = (Expression)params.get("preMove");
        if (isNoop) {
            GenericFileNoOpProcessStrategy strategy = new GenericFileNoOpProcessStrategy();
            strategy.setExclusiveReadLockStrategy(GenericFileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            return strategy;
        }
        if (isDelete) {
            GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
            strategy.setExclusiveReadLockStrategy(GenericFileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            return strategy;
        }
        if (moveExpression != null || preMoveExpression != null) {
            GenericFileExpressionRenamer renamer;
            FileRenameProcessStrategy strategy = new FileRenameProcessStrategy();
            strategy.setExclusiveReadLockStrategy(GenericFileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (moveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveExpression);
                strategy.setCommitRenamer(renamer);
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            return strategy;
        }
        GenericFileNoOpProcessStrategy strategy = new GenericFileNoOpProcessStrategy();
        strategy.setExclusiveReadLockStrategy(GenericFileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy strategy = (GenericFileExclusiveReadLockStrategy)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("rename".equals(readLock)) {
                GenericFileRenameExclusiveReadLockStrategy readLockStrategy = new GenericFileRenameExclusiveReadLockStrategy();
                Long timeout = (Long)params.get("readLockTimeout");
                if (timeout != null) {
                    readLockStrategy.setTimeout(timeout);
                }
                return readLockStrategy;
            }
        }
        return null;
    }
}

