/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnitOfWork
implements TraceableUnitOfWork,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultUnitOfWork.class);
    private static final UuidGenerator DEFAULT_ID_GENERATOR = new UuidGenerator();
    private String id;
    private List<Synchronization> synchronizations;
    private List<ProcessorDefinition> routeList;
    private Object originalInBody;

    public DefaultUnitOfWork(Exchange exchange) {
        this.originalInBody = exchange.getIn().getBody();
    }

    @Override
    public void start() throws Exception {
        this.id = null;
    }

    @Override
    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
            this.synchronizations = null;
        }
        if (this.routeList != null) {
            this.routeList.clear();
            this.routeList = null;
        }
        this.originalInBody = null;
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        for (Synchronization synchronization : this.synchronizations) {
            target.addOnCompletion(synchronization);
        }
        this.synchronizations.clear();
    }

    @Override
    public void done(Exchange exchange) {
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            boolean failed = exchange.isFailed();
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    if (failed) {
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception occured during onCompletion. This exception will be ignored: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = DEFAULT_ID_GENERATOR.generateId();
        }
        return this.id;
    }

    @Override
    public synchronized void addInterceptedNode(ProcessorDefinition node) {
        if (this.routeList == null) {
            this.routeList = new ArrayList<ProcessorDefinition>();
        }
        this.routeList.add(node);
    }

    @Override
    public synchronized ProcessorDefinition getLastInterceptedNode() {
        if (this.routeList == null || this.routeList.isEmpty()) {
            return null;
        }
        return this.routeList.get(this.routeList.size() - 1);
    }

    @Override
    public List<ProcessorDefinition> getInterceptedNodes() {
        return Collections.unmodifiableList(this.routeList);
    }

    @Override
    public Object getOriginalInBody() {
        return this.originalInBody;
    }
}

