/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;

public class DeadLetterChannel
extends ErrorHandlerSupport
implements Processor {
    private final Processor deadLetter;
    private final String deadLetterUri;
    private final Processor output;
    private final Processor redeliveryProcessor;
    private final RedeliveryPolicy redeliveryPolicy;
    private final Predicate handledPolicy;
    private final Logger logger;
    private final boolean useOriginalBodyPolicy;

    public DeadLetterChannel(Processor output, Processor deadLetter, String deadLetterUri, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Logger logger, ExceptionPolicyStrategy exceptionPolicyStrategy, Predicate handledPolicy, boolean useOriginalBodyPolicy) {
        this.output = output;
        this.deadLetter = deadLetter;
        this.deadLetterUri = deadLetterUri;
        this.redeliveryProcessor = redeliveryProcessor;
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.handledPolicy = handledPolicy;
        this.useOriginalBodyPolicy = useOriginalBodyPolicy;
        this.setExceptionPolicy(exceptionPolicyStrategy);
    }

    public String toString() {
        return "DeadLetterChannel[" + this.output + ", " + (this.deadLetterUri != null ? this.deadLetterUri : this.deadLetter) + "]";
    }

    public boolean supportTransacted() {
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        this.processErrorHandler(exchange, new RedeliveryData());
    }

    protected void processErrorHandler(Exchange exchange, RedeliveryData data) {
        while (true) {
            boolean done;
            boolean shouldRedeliver;
            if (!this.isRunAllowed()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Rejected execution as we are not started for exchange: " + exchange));
                }
                if (exchange.getException() == null) {
                    exchange.setException(new RejectedExecutionException());
                    return;
                }
            }
            if (exchange.isTransacted() && !this.supportTransacted() && exchange.getException() != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("This error handler does not support transacted exchanges. Bypassing this error handler: " + this + " for exchangeId: " + exchange.getExchangeId()));
                }
                return;
            }
            if (exchange.getException() != null) {
                this.handleException(exchange, data);
            }
            if (!(shouldRedeliver = this.shouldRedeliver(exchange, data))) {
                this.deliverToDeadLetterQueue(exchange, data);
                return;
            }
            if (data.redeliveryCounter > 0) {
                this.prepareExchangeForRedelivery(exchange);
                try {
                    data.redeliveryDelay = data.currentRedeliveryPolicy.sleep(data.redeliveryDelay, data.redeliveryCounter);
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
                    continue;
                }
                this.deliverToRedeliveryProcessor(exchange, data);
            }
            try {
                this.output.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (done = exchange.getException() == null || ExchangeHelper.isFailureHandled(exchange)) break;
        }
    }

    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void prepareExchangeForRedelivery(Exchange exchange) {
        if (exchange.getException() != null) {
            exchange.setException(null);
        }
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
    }

    private void handleException(Exchange exchange, RedeliveryData data) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(exchange.getContext(), data.currentRedeliveryPolicy);
            data.handledPredicate = exceptionPolicy.getHandledPolicy();
            data.retryUntilPredicate = exceptionPolicy.getRetryUntilPolicy();
            data.useOriginalInBody = exceptionPolicy.getUseOriginalBodyPolicy();
            Processor processor = exceptionPolicy.getErrorHandler();
            if (processor != null) {
                data.deadLetterQueue = processor;
            }
            if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                data.onRedeliveryProcessor = processor;
            }
        }
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId() + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e;
        this.logFailedDelivery(true, exchange, msg, data, e);
        data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e);
    }

    private void deliverToRedeliveryProcessor(Exchange exchange, RedeliveryData data) {
        if (data.onRedeliveryProcessor == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("RedeliveryProcessor " + data.onRedeliveryProcessor + " is processing Exchange: " + exchange + " before its redelivered"));
        }
        try {
            data.onRedeliveryProcessor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        this.log.trace((Object)"Redelivery processor done");
    }

    private void deliverToDeadLetterQueue(Exchange exchange, RedeliveryData data) {
        if (data.deadLetterQueue == null) {
            return;
        }
        ExchangeHelper.setFailureHandled(exchange);
        this.decrementRedeliveryCounter(exchange);
        MessageHelper.resetStreamCache(exchange.getIn());
        if (data.useOriginalInBody) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Using the original IN body in the DedLetterQueue instead of the current IN body");
            }
            Object original = exchange.getUnitOfWork().getOriginalInBody();
            exchange.getIn().setBody(original);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("DeadLetterQueue " + data.deadLetterQueue + " is processing Exchange: " + exchange));
        }
        try {
            data.deadLetterQueue.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        this.log.trace((Object)"DedLetterQueue processor done");
        this.prepareExchangeAfterMovedToDeadLetterQueue(exchange, data.handledPredicate);
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId() + ". Moved to the dead letter queue: " + data.deadLetterQueue;
        this.logFailedDelivery(false, exchange, msg, data, null);
    }

    private void prepareExchangeAfterMovedToDeadLetterQueue(Exchange exchange, Predicate handledPredicate) {
        if (handledPredicate == null || !handledPredicate.matches(exchange)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is not handled so its marked as failed: " + exchange));
            }
            exchange.setProperty("CamelExceptionHandled", Boolean.FALSE);
            exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is handled so its marked as not failed: " + exchange));
            }
            exchange.setProperty("CamelExceptionHandled", Boolean.TRUE);
        }
    }

    private void logFailedDelivery(boolean shouldRedeliver, Exchange exchange, String message, RedeliveryData data, Throwable e) {
        LoggingLevel newLogLevel = shouldRedeliver ? data.currentRedeliveryPolicy.getRetryAttemptedLogLevel() : data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
        if (exchange.isRollbackOnly()) {
            String msg = "Rollback exchange";
            if (exchange.getException() != null) {
                msg = msg + " due: " + exchange.getException().getMessage();
            }
            if (newLogLevel == LoggingLevel.ERROR || newLogLevel == LoggingLevel.FATAL) {
                this.logger.log(msg, LoggingLevel.WARN);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else if (data.currentRedeliveryPolicy.isLogStackTrace() && e != null) {
            this.logger.log(message, e, newLogLevel);
        } else {
            this.logger.log(message, newLogLevel);
        }
    }

    private boolean shouldRedeliver(Exchange exchange, RedeliveryData data) {
        return data.currentRedeliveryPolicy.shouldRedeliver(exchange, data.redeliveryCounter, data.retryUntilPredicate);
    }

    private int incrementRedeliveryCounter(Exchange exchange, Throwable e) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader("CamelRedeliveryCounter", next);
        in.setHeader("CamelRedelivered", Boolean.TRUE);
        return next;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", prev);
            in.setHeader("CamelRedelivered", prev > 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            in.setHeader("CamelRedeliveryCounter", 0);
            in.setHeader("CamelRedelivered", Boolean.FALSE);
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.deadLetter);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.deadLetter, this.output);
    }

    private class RedeliveryData {
        int redeliveryCounter;
        long redeliveryDelay;
        Predicate retryUntilPredicate;
        RedeliveryPolicy currentRedeliveryPolicy;
        Processor deadLetterQueue;
        Processor onRedeliveryProcessor;
        Predicate handledPredicate;
        boolean useOriginalInBody;

        private RedeliveryData() {
            this.currentRedeliveryPolicy = DeadLetterChannel.this.redeliveryPolicy;
            this.deadLetterQueue = DeadLetterChannel.this.deadLetter;
            this.onRedeliveryProcessor = DeadLetterChannel.this.redeliveryProcessor;
            this.handledPredicate = DeadLetterChannel.this.handledPolicy;
            this.useOriginalInBody = DeadLetterChannel.this.useOriginalBodyPolicy;
        }
    }
}

