/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultErrorHandler
extends ErrorHandlerSupport
implements Processor {
    private Processor output;

    public DefaultErrorHandler(Processor output, ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.output = output;
        this.setExceptionPolicy(exceptionPolicyStrategy);
    }

    public String toString() {
        return "DefaultErrorHandler[" + this.output + "]";
    }

    public boolean supportTransacted() {
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.output.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        boolean handle = true;
        if (exchange.isTransacted() && !this.supportTransacted()) {
            handle = false;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This error handler does not support transacted exchanges. Bypassing this error handler: " + this + " for exchangeId: " + exchange.getExchangeId()));
            }
        }
        if (handle && exchange.getException() != null && !ExchangeHelper.isFailureHandled(exchange)) {
            this.handleException(exchange);
        }
    }

    private void handleException(Exchange exchange) throws Exception {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            Predicate handledPredicate = exceptionPolicy.getHandledPolicy();
            Processor processor = exceptionPolicy.getErrorHandler();
            this.prepareExchangeBeforeOnException(exchange);
            if (processor != null) {
                this.deliverToFaultProcessor(exchange, processor);
            }
            this.prepareExchangeAfterOnException(exchange, handledPredicate);
        }
    }

    private void prepareExchangeBeforeOnException(Exchange exchange) {
        if (exchange.getException() != null) {
            exchange.setException(null);
        }
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
    }

    private void deliverToFaultProcessor(Exchange exchange, Processor failureProcessor) throws Exception {
        failureProcessor.process(exchange);
    }

    private void prepareExchangeAfterOnException(Exchange exchange, Predicate handledPredicate) {
        if (handledPredicate == null || !handledPredicate.matches(exchange)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is not handled so its marked as failed: " + exchange));
            }
            exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is handled so its marked as not failed: " + exchange));
            }
            exchange.setProperty("CamelExceptionHandled", Boolean.TRUE);
        }
    }

    public Processor getOutput() {
        return this.output;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.output);
    }
}

