/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.regex.PatternSyntaxException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EndpointHelper {
    private static final transient Log LOG = LogFactory.getLog(EndpointHelper.class);

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            consumer.start();
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                consumer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to stop PollingConsumer: " + e), (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(String uri, String pattern) {
        if (uri.equals(pattern)) {
            return true;
        }
        if (pattern.endsWith("*") && uri.startsWith(pattern.substring(0, pattern.length() - 1))) {
            return true;
        }
        try {
            if (uri.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }
}

