/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerBuilder
extends ErrorHandlerBuilderSupport
implements InitializingBean {
    private TransactionTemplate transactionTemplate;
    private ExceptionPolicyStrategy exceptionPolicyStrategy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public boolean supportTransacted() {
        return true;
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        TransactionErrorHandler answer = new TransactionErrorHandler(this.transactionTemplate, processor, this.exceptionPolicyStrategy);
        this.configure((ErrorHandler)answer);
        return answer;
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.transactionTemplate, (String)"transactionTemplate");
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setSpringTransactionPolicy(SpringTransactionPolicy policy) {
        this.transactionTemplate = policy.getTransactionTemplate();
    }

    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }

    public TransactionErrorHandlerBuilder exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }
}

