/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericFileDefaultSorter {
    private GenericFileDefaultSorter() {
    }

    public static Comparator<GenericFile> sortByName(final boolean reverse) {
        return new Comparator<GenericFile>(){

            @Override
            public int compare(GenericFile o1, GenericFile o2) {
                int answer = o1.getFileName().compareTo(o2.getFileName());
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<GenericFile> sortByPathName(final boolean reverse) {
        return new Comparator<GenericFile>(){

            @Override
            public int compare(GenericFile o1, GenericFile o2) {
                int answer = o1.getParent().compareTo(o2.getParent());
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<GenericFile> sortByLastModified(final boolean reverse) {
        return new Comparator<GenericFile>(){

            @Override
            public int compare(GenericFile o1, GenericFile o2) {
                long delta = o1.getLastModified() - o2.getLastModified();
                if (delta == 0L) {
                    return 0;
                }
                int answer = delta > 0L ? 1 : -1;
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<GenericFile> sortBySize(final boolean reverse) {
        return new Comparator<GenericFile>(){

            @Override
            public int compare(GenericFile o1, GenericFile o2) {
                long delta = o1.getFileLength() - o2.getFileLength();
                if (delta == 0L) {
                    return 0;
                }
                int answer = delta > 0L ? 1 : -1;
                return reverse ? -1 * answer : answer;
            }
        };
    }

    public static Comparator<GenericFileExchange> sortByFileLanguage(CamelContext context, String expression, boolean reverse) {
        return GenericFileDefaultSorter.sortByFileLanguage(context, expression, reverse, false, null);
    }

    public static Comparator<GenericFileExchange> sortByFileLanguage(CamelContext context, String expression, boolean reverse, boolean ignoreCase) {
        return GenericFileDefaultSorter.sortByFileLanguage(context, expression, reverse, ignoreCase, null);
    }

    public static Comparator<GenericFileExchange> sortByFileLanguage(final CamelContext context, final String expression, final boolean reverse, final boolean ignoreCase, final Comparator<GenericFileExchange> nested) {
        return new Comparator<GenericFileExchange>(){

            @Override
            public int compare(GenericFileExchange o1, GenericFileExchange o2) {
                Object result2;
                Language language = context.resolveLanguage("file");
                Expression exp = language.createExpression(expression);
                Object result1 = exp.evaluate(o1, Object.class);
                int answer = ObjectHelper.compare(result1, result2 = exp.evaluate(o2, Object.class), ignoreCase);
                if (answer == 0 && nested != null) {
                    answer = nested.compare(o1, o2);
                }
                return reverse ? -1 * answer : answer;
            }

            public String toString() {
                return expression + (nested != null ? ";" + nested.toString() : "");
            }
        };
    }
}

