/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint {
    private BlockingQueue<Exchange> queue;
    private int size = 1000;
    private int concurrentConsumers = 1;
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;
    private Set<SedaProducer> producers = new CopyOnWriteArraySet<SedaProducer>();
    private Set<SedaConsumer> consumers = new CopyOnWriteArraySet<SedaConsumer>();

    public SedaEndpoint() {
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue) {
        this(endpointUri, component, queue, 1);
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        super(endpointUri, component);
        this.queue = queue;
        this.concurrentConsumers = concurrentConsumers;
    }

    public SedaEndpoint(String endpointUri, BlockingQueue<Exchange> queue) {
        this(endpointUri, queue, 1);
    }

    public SedaEndpoint(String endpointUri, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        super(endpointUri);
        this.queue = queue;
        this.concurrentConsumers = concurrentConsumers;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SedaProducer(this, this.getQueue(), this.getWaitForTaskToComplete());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new SedaConsumer(this, processor);
    }

    public synchronized BlockingQueue<Exchange> getQueue() {
        if (this.queue == null) {
            this.queue = new LinkedBlockingQueue<Exchange>(this.size);
        }
        return this.queue;
    }

    public void setQueue(BlockingQueue<Exchange> queue) {
        this.queue = queue;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this.getQueue());
    }

    public Set<SedaConsumer> getConsumers() {
        return new HashSet<SedaConsumer>(this.consumers);
    }

    public Set<SedaProducer> getProducers() {
        return new HashSet<SedaProducer>(this.producers);
    }

    void onStarted(SedaProducer producer) {
        this.producers.add(producer);
    }

    void onStopped(SedaProducer producer) {
        this.producers.remove(producer);
    }

    void onStarted(SedaConsumer consumer) {
        this.consumers.add(consumer);
    }

    void onStopped(SedaConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

