/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.idempotent.IdempotentOnCompletion;
import org.apache.camel.processor.idempotent.NoMessageIdException;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdempotentConsumer
extends ServiceSupport
implements Processor,
Navigate<Processor> {
    private static final transient Log LOG = LogFactory.getLog(IdempotentConsumer.class);
    private final Expression messageIdExpression;
    private final Processor processor;
    private final IdempotentRepository idempotentRepository;
    private final boolean eager;

    public IdempotentConsumer(Expression messageIdExpression, IdempotentRepository idempotentRepository, boolean eager, Processor processor) {
        this.messageIdExpression = messageIdExpression;
        this.idempotentRepository = idempotentRepository;
        this.eager = eager;
        this.processor = processor;
    }

    public String toString() {
        return "IdempotentConsumer[" + this.messageIdExpression + " -> " + this.processor + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        boolean newKey;
        String messageId = this.messageIdExpression.evaluate(exchange, String.class);
        if (messageId == null) {
            throw new NoMessageIdException(exchange, this.messageIdExpression);
        }
        if (this.eager) {
            newKey = this.idempotentRepository.add(messageId);
        } else {
            boolean bl = newKey = !this.idempotentRepository.contains(messageId);
        }
        if (!newKey) {
            this.onDuplicateMessage(exchange, messageId);
            return;
        }
        exchange.addOnCompletion(new IdempotentOnCompletion(this.idempotentRepository, messageId, this.eager));
        this.processor.process(exchange);
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    public Expression getMessageIdExpression() {
        return this.messageIdExpression;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }

    protected void onDuplicateMessage(Exchange exchange, String messageId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignoring duplicate message with id: " + messageId + " for exchange: " + exchange));
        }
    }
}

