/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.MessageHeaderFilter;
import org.apache.camel.component.cxf.SoapMessageHeaderFilter;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfHeaderFilterStrategy
extends DefaultHeaderFilterStrategy {
    private static final Log LOG = LogFactory.getLog(CxfHeaderFilterStrategy.class);
    private Map<String, MessageHeaderFilter> messageHeaderFiltersMap;
    private List<MessageHeaderFilter> messageHeaderFilters;
    private boolean relayHeaders = true;
    private boolean allowFilterNamespaceClash;
    private boolean relayAllMessageHeaders;

    public CxfHeaderFilterStrategy() {
        this.initialize();
    }

    protected void initialize() {
        this.getOutFilter().add("operationName");
        this.getOutFilter().add("operationNameSpace");
        this.getOutFilter().add("RequestContext");
        this.getOutFilter().add("ResponseContext");
        this.getOutFilter().add(Message.PROTOCOL_HEADERS);
        this.getInFilter().add(Message.PROTOCOL_HEADERS);
        this.getOutFilter().add("content-type");
        this.messageHeaderFiltersMap = new HashMap<String, MessageHeaderFilter>();
        this.addToMessageHeaderFilterMap(new SoapMessageHeaderFilter());
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String key, Object value, Exchange exchange) {
        block8: {
            if (!Header.HEADER_LIST.equals(key) || value == null) {
                return false;
            }
            if (!this.relayHeaders) {
                return true;
            }
            if (this.relayAllMessageHeaders) {
                return false;
            }
            MessageHeaderFilter messageHeaderfilter = this.getMessageHeaderFilter(exchange);
            if (messageHeaderfilter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No CXF Binding namespace can be resolved.  Message headers are intact.");
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("messageHeaderfilter = " + messageHeaderfilter));
            }
            try {
                messageHeaderfilter.filter(direction, (List)value);
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)("Failed to cast value to Header<List> due to " + t.toString()), t);
            }
        }
        return false;
    }

    private void addToMessageHeaderFilterMap(MessageHeaderFilter filter) {
        for (String ns : filter.getActivationNamespaces()) {
            if (this.messageHeaderFiltersMap.containsKey(ns) && this.messageHeaderFiltersMap.get(ns) != this.messageHeaderFiltersMap && !this.allowFilterNamespaceClash) {
                throw new IllegalArgumentException("More then one MessageHeaderRelay activates for the same namespace: " + ns);
            }
            this.messageHeaderFiltersMap.put(ns, filter);
        }
    }

    private MessageHeaderFilter getMessageHeaderFilter(Exchange exchange) {
        BindingInfo b;
        BindingOperationInfo boi = (BindingOperationInfo)exchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        String ns = null;
        if (boi != null && (b = boi.getBinding()) != null) {
            ns = b.getBindingId();
        }
        MessageHeaderFilter answer = null;
        if (ns != null) {
            answer = this.messageHeaderFiltersMap.get(ns);
        }
        return answer;
    }

    public void setMessageHeaderFilters(List<MessageHeaderFilter> messageHeaderFilters) {
        this.messageHeaderFilters = messageHeaderFilters;
        this.messageHeaderFiltersMap.clear();
        for (MessageHeaderFilter filter : messageHeaderFilters) {
            this.addToMessageHeaderFilterMap(filter);
        }
    }

    public List<MessageHeaderFilter> getMessageHeaderFilters() {
        return this.messageHeaderFilters;
    }

    public boolean isAllowFilterNamespaceClash() {
        return this.allowFilterNamespaceClash;
    }

    public void setAllowFilterNamespaceClash(boolean allowFilterNamespaceClash) {
        this.allowFilterNamespaceClash = allowFilterNamespaceClash;
    }

    public Map<String, MessageHeaderFilter> getMessageHeaderFiltersMap() {
        return this.messageHeaderFiltersMap;
    }

    public void setRelayHeaders(boolean relayHeaders) {
        this.relayHeaders = relayHeaders;
    }

    public boolean isRelayHeaders() {
        return this.relayHeaders;
    }

    public boolean isRelayAllMessageHeaders() {
        return this.relayAllMessageHeaders;
    }

    public void setRelayAllMessageHeaders(boolean relayAllMessageHeaders) {
        this.relayAllMessageHeaders = relayAllMessageHeaders;
    }
}

