/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.cxfbean.CxfBeanBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCxfBeanBinding
implements CxfBeanBinding {
    private static final Log LOG = LogFactory.getLog(DefaultCxfBeanBinding.class);

    public org.apache.cxf.message.Message createCxfMessageFromCamelExchange(Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        Message camelMessage = camelExchange.getIn();
        String requestContentType = this.getRequestContentType(camelMessage);
        String acceptContentTypes = (String)camelMessage.getHeader("Accept", String.class);
        if (acceptContentTypes == null) {
            acceptContentTypes = "*/*";
        }
        String enc = this.getCharacterEncoding(camelMessage);
        String path = this.getPath(camelMessage);
        String basePath = this.getBasePath(camelExchange);
        String verb = this.getVerb(camelMessage);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing " + camelExchange + ", requestContentType = " + requestContentType + ", acceptContentTypes = " + acceptContentTypes + ", encoding = " + enc + ", path = " + path + ", basePath = " + basePath + ", verb = " + verb));
        }
        org.apache.cxf.message.Message answer = CxfSoapBinding.getCxfInMessage(headerFilterStrategy, camelExchange, false);
        answer.put((Object)org.apache.cxf.message.Message.REQUEST_URI, (Object)path);
        answer.put((Object)org.apache.cxf.message.Message.BASE_PATH, (Object)basePath);
        answer.put((Object)org.apache.cxf.message.Message.HTTP_REQUEST_METHOD, (Object)verb);
        answer.put((Object)org.apache.cxf.message.Message.PATH_INFO, (Object)path);
        answer.put((Object)"Content-Type", (Object)requestContentType);
        answer.put((Object)"Accept", (Object)acceptContentTypes);
        answer.put((Object)org.apache.cxf.message.Message.ENCODING, (Object)enc);
        return answer;
    }

    protected String getPath(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpPath", String.class);
        return answer;
    }

    protected String getBasePath(Exchange camelExchange) {
        String answer = (String)camelExchange.getIn().getHeader("CamelCxfBeanRequestBasePath", String.class);
        if (answer == null) {
            answer = camelExchange.getFromEndpoint().getEndpointUri();
        }
        return answer;
    }

    protected String getVerb(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpMethod", String.class);
        return answer;
    }

    protected String getCharacterEncoding(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpCharacterEncoding", String.class);
        if (answer == null) {
            answer = (String)camelMessage.getHeader("CamelCharsetName", String.class);
        }
        return answer;
    }

    protected String getRequestContentType(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelContentType", String.class);
        if (answer != null) {
            return answer;
        }
        return "*/*";
    }
}

