/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.component.cxf.spring.CxfRsClientFactoryBeanDefinitionParser;
import org.apache.camel.component.cxf.spring.CxfRsServerFactoryBeanDefinitionParser;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private List<Class> resourceClasses;
    private HeaderFilterStrategy headerFilterStrategy;
    private CxfRsBinding binding;

    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfRsConsumer(this, processor);
    }

    public Producer createProducer() throws Exception {
        return new CxfRsProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
    }

    public CxfRsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultCxfRsBinding();
        }
        return this.binding;
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        sfb.setAddress(this.getEndpointUri());
        sfb.setResourceClasses(this.getResourceClasses());
        sfb.setStart(false);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb) {
        cfb.setAddress(this.getEndpointUri());
        cfb.setResourceClass(this.getResourceClasses().get(0));
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        CxfRsServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean answer = new CxfRsServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        CxfRsClientFactoryBeanDefinitionParser.SpringJAXRSClientFactoryBean answer = new CxfRsClientFactoryBeanDefinitionParser.SpringJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer);
        return answer;
    }

    public List<Class> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<Class> classes) {
        this.resourceClasses = classes;
    }

    public void setResourceClasses(Class ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }
}

