/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.nio.SelectorWorker;

public final class SelectorManager {
    public static final SelectorManager SINGLETON = new SelectorManager();
    private Executor selectorExecutor;
    private Executor channelExecutor;
    private LinkedList<SelectorWorker> freeWorkers;
    private int maxChannelsPerWorker;

    public SelectorManager() {
        this.channelExecutor = this.selectorExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread rc = new Thread(r);
                rc.setName("NIO Transport Thread");
                return rc;
            }
        });
        this.freeWorkers = new LinkedList();
        this.maxChannelsPerWorker = 64;
    }

    static SelectorManager getInstance() {
        return SINGLETON;
    }

    public synchronized SelectorSelection register(SocketChannel socketChannel, Listener listener) throws IOException {
        SelectorWorker worker = null;
        if (this.freeWorkers.size() > 0) {
            worker = this.freeWorkers.getFirst();
        } else {
            worker = new SelectorWorker(this);
            this.freeWorkers.addFirst(worker);
        }
        SelectorSelection selection = new SelectorSelection(worker, socketChannel, listener);
        return selection;
    }

    synchronized void onWorkerFullEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerEmptyEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerNotFullEvent(SelectorWorker worker) {
        this.freeWorkers.add(worker);
    }

    public Executor getChannelExecutor() {
        return this.channelExecutor;
    }

    public void setChannelExecutor(Executor channelExecutor) {
        this.channelExecutor = channelExecutor;
    }

    public int getMaxChannelsPerWorker() {
        return this.maxChannelsPerWorker;
    }

    public void setMaxChannelsPerWorker(int maxChannelsPerWorker) {
        this.maxChannelsPerWorker = maxChannelsPerWorker;
    }

    public Executor getSelectorExecutor() {
        return this.selectorExecutor;
    }

    public void setSelectorExecutor(Executor selectorExecutor) {
        this.selectorExecutor = selectorExecutor;
    }

    public static interface Listener {
        public void onSelect(SelectorSelection var1);

        public void onError(SelectorSelection var1, Throwable var2);
    }
}

