/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.ws.WebServiceProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultCxfBinding;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(CxfEndpoint.class);
    private String wsdlURL;
    private String serviceClass;
    private String portName;
    private String serviceName;
    private DataFormat dataFormat = DataFormat.POJO;
    private boolean isWrapped;
    private boolean inOut = true;
    private Bus bus;
    private CxfBinding cxfBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private AtomicBoolean cxfBindingInitialized = new AtomicBoolean(false);
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    private boolean isSetDefaultBus;

    public CxfEndpoint(String remaining, CxfComponent cxfComponent) {
        super(remaining, (Component)cxfComponent);
    }

    public CxfEndpoint(String remaining, CamelContext context) {
        super(remaining, context);
    }

    public Producer createProducer() throws Exception {
        return new CxfProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void setupServerFactoryBean(ServerFactoryBean sfb, Class<?> cls) {
        sfb.setAddress(this.getEndpointUri());
        sfb.setServiceClass(cls);
        if (this.getWsdlURL() != null) {
            sfb.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            sfb.setServiceName(CxfEndpointUtils.getQName(this.getServiceName()));
        }
        if (this.getPortName() != null) {
            sfb.setEndpointName(CxfEndpointUtils.getQName(this.getPortName()));
        }
        if (!CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class)) {
            if (this.getDataFormat() == DataFormat.PAYLOAD) {
                sfb.getFeatures().add(new PayLoadDataFormatFeature());
            } else if (this.getDataFormat() == DataFormat.MESSAGE) {
                sfb.getFeatures().add(new MessageDataFormatFeature());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignore DataFormat mode " + (Object)((Object)this.getDataFormat()) + " since SEI class is annotated with WebServiceProvider"));
        }
        sfb.setBus(this.getBus());
        sfb.setStart(false);
    }

    protected ClientProxyFactoryBean createClientFactoryBean(Class<?> cls) throws CamelException {
        ObjectHelper.notNull(cls, (String)"Please provide endpoint service interface class");
        if (CxfEndpointUtils.hasWebServiceAnnotation(cls)) {
            return new JaxWsProxyFactoryBean((ClientFactoryBean)new JaxWsClientFactoryBean(){

                protected void createClient(Endpoint ep) {
                    this.setClient((Client)new CamelCxfClientImpl(this.getBus(), ep));
                }
            });
        }
        return new ClientProxyFactoryBean(new ClientFactoryBean(){

            protected void createClient(Endpoint ep) {
                this.setClient((Client)new CamelCxfClientImpl(this.getBus(), ep));
            }
        });
    }

    protected Bus doGetBus() {
        return BusFactory.getDefaultBus();
    }

    protected void setupClientFactoryBean(ClientProxyFactoryBean factoryBean, Class<?> cls) {
        ObjectHelper.notNull(cls, (String)"Please provide endpoint service interface class");
        factoryBean.setServiceClass(cls);
        factoryBean.setAddress(this.getEndpointUri());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            factoryBean.setServiceName(CxfEndpointUtils.getQName(this.getServiceName()));
        }
        if (this.getPortName() != null) {
            factoryBean.setEndpointName(CxfEndpointUtils.getQName(this.getPortName()));
        }
        if (this.getDataFormat() == DataFormat.MESSAGE) {
            factoryBean.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature());
        }
        factoryBean.setBus(this.getBus());
    }

    Client createClient() throws Exception {
        ObjectHelper.notEmpty((String)this.getServiceClass(), (String)"serviceClass");
        Class cls = ClassLoaderUtils.loadClass((String)this.getServiceClass(), ((Object)((Object)this)).getClass());
        ClientProxyFactoryBean factoryBean = this.createClientFactoryBean(cls);
        this.setupClientFactoryBean(factoryBean, cls);
        return ((ClientProxy)Proxy.getInvocationHandler(factoryBean.create())).getClient();
    }

    ServerFactoryBean createServerFactoryBean() throws Exception {
        ObjectHelper.notEmpty((String)this.getServiceClass(), (String)"serviceClass");
        Class cls = ClassLoaderUtils.loadClass((String)this.getServiceClass(), ((Object)((Object)this)).getClass());
        Object answer = null;
        answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String className) {
        this.serviceClass = className;
    }

    public void setServiceClass(Object instance) {
        this.serviceClass = ClassHelper.getRealClass((Object)instance).getName();
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public void setCxfBinding(CxfBinding cxfBinding) {
        this.cxfBinding = cxfBinding;
        this.cxfBindingInitialized.set(false);
    }

    public CxfBinding getCxfBinding() {
        if (this.cxfBinding == null) {
            this.cxfBinding = new DefaultCxfBinding();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create default CXF Binding " + this.cxfBinding));
            }
        }
        if (!this.cxfBindingInitialized.getAndSet(true) && this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        return this.cxfBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfHeaderFilterStrategy();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create CXF default header filter strategy " + this.headerFilterStrategy));
            }
        }
        return this.headerFilterStrategy;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = this.doGetBus();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using DefaultBus " + this.bus));
            }
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Set bus " + this.bus + " as thread default bus"));
            }
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    private class CamelCxfClientImpl
    extends ClientImpl {
        public CamelCxfClientImpl(Bus bus, Endpoint ep) {
            super(bus, ep);
        }

        protected void setParameters(Object[] params, Message message) {
            if (DataFormat.PAYLOAD == message.get(DataFormat.class)) {
                CxfPayload payload = (CxfPayload)params[0];
                message.put(List.class, payload.getBody());
                message.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                super.setParameters(params, message);
            }
        }
    }
}

