/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.Serializable;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.component.file.GenericFileDefaultBinding;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFile<T>
implements Cloneable,
Serializable {
    private static final Log LOG = LogFactory.getLog(GenericFile.class);
    private String endpointPath;
    private String fileName;
    private String fileNameOnly;
    private String relativeFilePath;
    private String absoluteFilePath;
    private long fileLength;
    private long lastModified;
    private T file;
    private GenericFileBinding<T> binding;
    private boolean absolute;

    public char getFileSeparator() {
        return File.separatorChar;
    }

    public GenericFile<T> clone() {
        return this.copyFrom(this);
    }

    public GenericFile<T> copyFrom(GenericFile<T> source) {
        GenericFile result;
        try {
            result = (GenericFile)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        result.setEndpointPath(source.getEndpointPath());
        result.setAbsolute(source.isAbsolute());
        result.setAbsoluteFilePath(source.getAbsoluteFilePath());
        result.setRelativeFilePath(source.getRelativeFilePath());
        result.setFileName(source.getFileName());
        result.setFileNameOnly(source.getFileNameOnly());
        result.setFileLength(source.getFileLength());
        result.setLastModified(source.getLastModified());
        result.setFile(source.getFile());
        result.setBody(source.getBody());
        result.setBinding(source.getBinding());
        return result;
    }

    protected boolean isAbsolute(String name) {
        File file = new File(name);
        return file.isAbsolute();
    }

    protected String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    public void changeFileName(String newName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Changing name to: " + newName));
        }
        String newFileName = this.normalizePath(newName);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Normalized endpointPath: " + this.endpointPath));
            LOG.trace((Object)("Normalized newFileName: " + newFileName));
        }
        File file = new File(newFileName);
        if (!this.absolute && ObjectHelper.isNotEmpty(this.endpointPath) && newFileName.startsWith(this.endpointPath)) {
            newFileName = ObjectHelper.after(newFileName, this.endpointPath + this.getFileSeparator());
            file = new File(newFileName);
        }
        this.setFileNameOnly(file.getName());
        this.setFileName(file.getName());
        if (file.getParent() != null) {
            this.setRelativeFilePath(file.getParent() + this.getFileSeparator() + file.getName());
        } else {
            this.setRelativeFilePath(file.getName());
        }
        if (this.isAbsolute(newFileName)) {
            this.setAbsolute(true);
            this.setAbsoluteFilePath(newFileName);
        } else {
            this.setAbsolute(false);
            String path = ObjectHelper.isEmpty(this.endpointPath) ? "" : this.endpointPath + this.getFileSeparator();
            this.setAbsoluteFilePath(path + this.getRelativeFilePath());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("FileNameOnly: " + this.getFileNameOnly()));
            LOG.trace((Object)("FileName: " + this.getFileName()));
            LOG.trace((Object)("Absolute: " + this.isAbsolute()));
            LOG.trace((Object)("Relative path: " + this.getRelativeFilePath()));
            LOG.trace((Object)("Absolute path: " + this.getAbsoluteFilePath()));
            LOG.trace((Object)("Name changed to: " + this));
        }
    }

    public String getRelativeFilePath() {
        return this.relativeFilePath;
    }

    public void setRelativeFilePath(String relativeFilePath) {
        this.relativeFilePath = this.normalizePathToProtocol(relativeFilePath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = this.normalizePathToProtocol(fileName);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public T getFile() {
        return this.file;
    }

    public void setFile(T file) {
        this.file = file;
    }

    public Object getBody() {
        return this.getBinding().getBody(this);
    }

    public void setBody(Object os) {
        this.getBinding().setBody(this, os);
    }

    public String getParent() {
        String parent;
        if (this.isAbsolute()) {
            String name = this.getAbsoluteFilePath();
            File path = new File(name);
            parent = path.getParent();
        } else {
            String name = this.getRelativeFilePath();
            File path = new File(this.endpointPath, name);
            parent = path.getParent();
        }
        return this.normalizePathToProtocol(parent);
    }

    public GenericFileBinding<T> getBinding() {
        if (this.binding == null) {
            this.binding = new GenericFileDefaultBinding();
        }
        return this.binding;
    }

    public void setBinding(GenericFileBinding<T> binding) {
        this.binding = binding;
    }

    public void setAbsoluteFilePath(String absoluteFilePath) {
        this.absoluteFilePath = this.normalizePathToProtocol(absoluteFilePath);
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public void setEndpointPath(String endpointPath) {
        this.endpointPath = this.normalizePathToProtocol(endpointPath);
    }

    public String getFileNameOnly() {
        return this.fileNameOnly;
    }

    public void setFileNameOnly(String fileNameOnly) {
        this.fileNameOnly = fileNameOnly;
    }

    protected String normalizePathToProtocol(String path) {
        if (ObjectHelper.isEmpty(path)) {
            return path;
        }
        path = path.replace('/', this.getFileSeparator());
        path = path.replace('\\', this.getFileSeparator());
        return path;
    }

    public String toString() {
        return "GenericFile[" + (this.absolute ? this.absoluteFilePath : this.relativeFilePath) + "]";
    }
}

