/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumerAware;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.impl.DefaultExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileExchange<T>
extends DefaultExchange
implements PollingConsumerAware {
    private GenericFile<T> file;

    public GenericFileExchange(Endpoint fromEndpoint) {
        super(fromEndpoint);
    }

    public GenericFileExchange(DefaultExchange parent, GenericFile<T> file) {
        super(parent);
        this.setGenericFile(file);
    }

    protected void populateHeaders(GenericFile<T> file) {
        if (file != null) {
            this.getIn().setHeader("CamelFileNameOnly", file.getFileNameOnly());
            this.getIn().setHeader("CamelFileName", file.getFileName());
            this.getIn().setHeader("CamelFileAbsolute", file.isAbsolute());
            this.getIn().setHeader("CamelFileAbsolutePath", file.getAbsoluteFilePath());
            if (file.isAbsolute()) {
                this.getIn().setHeader("CamelFilePath", file.getAbsoluteFilePath());
            } else {
                String path = file.normalizePathToProtocol(file.getEndpointPath() + File.separator + file.getRelativeFilePath());
                this.getIn().setHeader("CamelFilePath", path);
            }
            this.getIn().setHeader("CamelFileRelativePath", file.getRelativeFilePath());
            this.getIn().setHeader("CamelFileParent", file.getParent());
            if (file.getFileLength() > 0L) {
                this.getIn().setHeader("CamelFileLength", file.getFileLength());
            }
            if (file.getLastModified() > 0L) {
                this.getIn().setHeader("CamelFileLastModified", new Date(file.getLastModified()));
            }
        }
    }

    public GenericFile<T> getGenericFile() {
        return this.file;
    }

    public void setGenericFile(GenericFile<T> file) {
        this.file = file;
        this.setIn(new GenericFileMessage<T>(file));
        this.populateHeaders(file);
    }

    @Override
    public Exchange newInstance() {
        return new GenericFileExchange<T>(this, this.file);
    }

    @Override
    public void exchangePolled(Exchange exchange) {
        try {
            this.file.getBinding().loadContent(exchange, this.file);
        }
        catch (IOException e) {
            throw new RuntimeExchangeException("Cannot load content of file: " + this.file.getAbsoluteFilePath(), exchange, e);
        }
    }
}

