/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileProducer<T>
extends DefaultProducer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected final GenericFileEndpoint<T> endpoint;
    protected final GenericFileOperations<T> operations;

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    protected String getFileSeparator() {
        return File.separator;
    }

    protected String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        GenericFileExchange fileExchange = (GenericFileExchange)this.endpoint.createExchange(exchange);
        this.processExchange(fileExchange);
        ExchangeHelper.copyResults(exchange, fileExchange);
    }

    protected void processExchange(GenericFileExchange<T> exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing " + exchange));
        }
        try {
            String target = this.createFileName(exchange);
            this.preWriteCheck();
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty(this.endpoint.getTempPrefix());
            String tempTarget = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(target);
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                boolean renamed;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Renaming file: [" + tempTarget + "] to: [" + target + "]"));
                }
                if (!(renamed = this.operations.renameFile(tempTarget, target))) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            exchange.getIn().setHeader("CamelFileNameProduced", target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
    }

    protected void handleFailedWrite(GenericFileExchange<T> exchange, Exception exception) throws Exception {
        throw exception;
    }

    protected void preWriteCheck() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(GenericFileExchange<T> exchange, String fileName) throws GenericFileOperationFailedException {
        InputStream payload = exchange.getIn().getBody(InputStream.class);
        try {
            boolean success;
            if (this.endpoint.isAutoCreate()) {
                File file = new File(fileName);
                String directory = file.getParent();
                boolean absolute = file.isAbsolute();
                if (directory != null && !this.operations.buildDirectory(directory, absolute)) {
                    this.log.debug((Object)("Cannot build directory [" + directory + "] (could be because of denied permissions)"));
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("About to write [" + fileName + "] to [" + this.getEndpoint() + "] from exchange [" + exchange + "]"));
            }
            if (!(success = this.operations.storeFile(fileName, exchange))) {
                throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Wrote [" + fileName + "] to [" + this.getEndpoint() + "]"));
            }
        }
        finally {
            ObjectHelper.close(payload, "Closing payload", this.log);
        }
    }

    protected String createFileName(Exchange exchange) {
        String name = exchange.getIn().getHeader("CamelFileName", String.class);
        Expression expression = this.endpoint.getFileName();
        if (name != null && name.indexOf("${") > -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CamelFileName contains a FileLanguage expression: " + name));
            }
            Language language = this.getEndpoint().getCamelContext().resolveLanguage("file");
            expression = language.createExpression(name);
        }
        if (expression != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename evaluated as expression: " + expression));
            }
            name = expression.evaluate(exchange, String.class);
        }
        if (name != null && this.endpoint.isFlatten()) {
            int pos = name.lastIndexOf(this.getFileSeparator());
            if (pos == -1) {
                pos = name.lastIndexOf(47);
            }
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            baseDir = endpointPath + (endpointPath.endsWith(this.getFileSeparator()) ? "" : this.getFileSeparator());
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        answer = this.normalizePath(answer);
        return answer;
    }

    protected String createTempFileName(String fileName) {
        int path = (fileName = this.normalizePath(fileName)).lastIndexOf(this.getFileSeparator());
        if (path == -1) {
            return this.endpoint.getTempPrefix() + fileName;
        }
        StringBuilder sb = new StringBuilder(fileName);
        sb.insert(path + 1, this.endpoint.getTempPrefix());
        return sb.toString();
    }
}

