/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerFileExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final transient Log LOG = LogFactory.getLog(MarkerFileExclusiveReadLockStrategy.class);

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> fileGenericFileOperations, GenericFile<File> file, Exchange exchange) throws Exception {
        FileChannel channel;
        FileLock lock;
        String lockFileName = file.getAbsoluteFilePath() + ".camelLock";
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Locking the file: " + file + " using the lock file name: " + lockFileName));
        }
        if ((lock = (channel = new RandomAccessFile(lockFileName, "rw").getChannel()).lock()) != null) {
            exchange.setProperty("CamelFileLock", lock);
            exchange.setProperty("CamelFileLockName", lockFileName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        FileLock lock = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLock", FileLock.class);
        String lockFileName = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLockName", String.class);
        FileChannel channel = lock.channel();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Unlocking file: " + lockFileName));
        }
        try {
            lock.release();
        }
        finally {
            ObjectHelper.close(channel, "Closing channel", LOG);
            File lockfile = new File(lockFileName);
            boolean deleted = lockfile.delete();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Lock file: " + lockFileName + " was deleted: " + deleted));
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
    }
}

