/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.IsSingleton;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.Routes;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultExchangeConverter;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultLifecycleStrategy;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.DefaultProducerServicePool;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.RouteService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.WebSpherePacakageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.management.InstrumentationLifecycleStrategy;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.ExchangeConverter;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.SystemHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCamelContext
extends ServiceSupport
implements CamelContext,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultCamelContext.class);
    private static final String NAME_PREFIX = "camel-";
    private static int nameSuffix;
    private boolean routeDefinitionInitiated;
    private String name;
    private final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private List<Route> routes;
    private final List<Service> servicesToClose = new ArrayList<Service>();
    private TypeConverter typeConverter;
    private TypeConverterRegistry typeConverterRegistry;
    private ExchangeConverter exchangeConverter;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private Registry registry;
    private LifecycleStrategy lifecycleStrategy;
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private Boolean trace;
    private Boolean streamCache = Boolean.TRUE;
    private Boolean handleFault = Boolean.FALSE;
    private Long delay;
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private Map<String, String> properties = new HashMap<String, String>();
    private FactoryFinderResolver factoryFinderResolver = new DefaultFactoryFinderResolver();
    private FactoryFinder defaultFactoryFinder;
    private final Map<String, FactoryFinder> factories = new HashMap<String, FactoryFinder>();
    private final Map<String, RouteService> routeServices = new HashMap<String, RouteService>();
    private ClassResolver classResolver;
    private PackageScanClassResolver packageScanClassResolver;
    private ServicePool<Endpoint, Producer> producerServicePool = new DefaultProducerServicePool(100);

    public DefaultCamelContext() {
        this.name = NAME_PREFIX + ++nameSuffix;
        if (Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            LOG.info((Object)"JMX is disabled. Using DefaultLifecycleStrategy.");
            this.lifecycleStrategy = new DefaultLifecycleStrategy();
        } else {
            try {
                LOG.info((Object)"JMX enabled. Using InstrumentationLifecycleStrategy.");
                this.lifecycleStrategy = new InstrumentationLifecycleStrategy();
            }
            catch (NoClassDefFoundError e) {
                LOG.warn((Object)("Could not find needed classes for JMX lifecycle strategy. Needed class is in spring-context.jar using Spring 2.5 or newer ( spring-jmx.jar using Spring 2.0.x). NoClassDefFoundError: " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not create JMX lifecycle strategy, caused by: " + e.getMessage()));
            }
            if (this.lifecycleStrategy == null) {
                LOG.warn((Object)"Cannot use JMX lifecycle strategy. Using DefaultLifecycleStrategy instead.");
                this.lifecycleStrategy = new DefaultLifecycleStrategy();
            }
        }
        if (this.classResolver == null) {
            this.classResolver = new DefaultClassResolver();
        }
        if (this.packageScanClassResolver == null) {
            if (WebSpherePacakageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
                LOG.info((Object)"Using WebSphere specific PackageScanClassResolver");
                this.packageScanClassResolver = new WebSpherePacakageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
            } else {
                this.packageScanClassResolver = new DefaultPackageScanClassResolver();
            }
        }
    }

    public DefaultCamelContext(Context jndiContext) {
        this();
        this.setJndiContext(jndiContext);
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull(component, "component");
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && this.autoCreateComponents) {
                try {
                    component = this.getComponentResolver().resolveComponent(name, this);
                    if (component != null) {
                        this.addComponent(name, component);
                        if (this.isStarted() || this.isStarting()) {
                            ServiceHelper.startServices(component);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Could not auto create component: " + name, e);
                }
            }
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        throw new IllegalArgumentException("The component is not of type: " + componentType + " but is: " + component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            return this.components.remove(componentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getOrCreateComponent(String componentName, Callable<Component> factory) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(componentName);
            if (component == null) {
                try {
                    component = factory.call();
                    if (component == null) {
                        throw new RuntimeCamelException("Factory failed to create the " + componentName + " component, it returned null.");
                    }
                    this.components.put(componentName, component);
                    component.setCamelContext(this);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Factory failed to create the " + componentName + " component", e);
                }
            }
            return component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<Endpoint>(this.endpoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Endpoint> getEndpointMap() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new TreeMap<String, Endpoint>(this.endpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints(String uri) {
        ArrayList<Endpoint> coll;
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint ep = this.endpoints.get(uri);
            if (ep != null) {
                answer.add(ep);
                return answer;
            }
            coll = new ArrayList<Endpoint>(this.endpoints.values());
        }
        for (Endpoint ep : coll) {
            if (ep.isSingleton() || !uri.equals(ep.getEndpointUri())) continue;
            answer.add(ep);
        }
        return answer;
    }

    @Override
    public Collection<Endpoint> getSingletonEndpoints() {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Collection<Endpoint> coll = this.getEndpoints();
        for (Endpoint ep : coll) {
            if (!ep.isSingleton()) continue;
            answer.add(ep);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        Endpoint oldEndpoint;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            ServiceHelper.startServices(endpoint);
            oldEndpoint = this.endpoints.remove(uri);
            this.addEndpointToRegistry(uri, endpoint);
            if (oldEndpoint != null) {
                ServiceHelper.stopServices(oldEndpoint);
            }
        }
        return oldEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint oldEndpoint = this.endpoints.remove(uri);
            if (oldEndpoint != null) {
                answer.add(oldEndpoint);
                ServiceHelper.stopServices(oldEndpoint);
            } else {
                for (Map.Entry<String, Endpoint> entry : this.endpoints.entrySet()) {
                    oldEndpoint = entry.getValue();
                    if (oldEndpoint.isSingleton() || !uri.equals(oldEndpoint.getEndpointUri())) continue;
                    answer.add(oldEndpoint);
                    ServiceHelper.stopServices(oldEndpoint);
                    this.endpoints.remove(entry.getKey());
                }
            }
        }
        return answer;
    }

    public Endpoint addSingletonEndpoint(String uri, Endpoint endpoint) throws Exception {
        return this.addEndpoint(uri, endpoint);
    }

    public Endpoint removeSingletonEndpoint(String uri) throws Exception {
        Collection<Endpoint> answer = this.removeEndpoints(uri);
        return (Endpoint)(answer.size() > 0 ? answer.toArray()[0] : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getEndpoint(String uri) {
        Endpoint answer;
        ObjectHelper.notEmpty(uri, "uri");
        String scheme = null;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            answer = this.endpoints.get(uri);
            if (answer == null) {
                try {
                    Component component;
                    String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                    if (splitURI[1] != null && (component = this.getComponent(scheme = splitURI[0])) != null && (answer = component.createEndpoint(uri)) != null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)(uri + " converted to endpoint: " + answer + " by component: " + component));
                    }
                    if (answer == null) {
                        answer = this.createEndpoint(uri);
                    }
                    if (answer != null) {
                        this.addService(answer);
                        Endpoint newAnswer = this.addEndpointToRegistry(uri, answer);
                        this.lifecycleStrategy.onEndpointAdd(answer);
                        answer = newAnswer;
                    }
                }
                catch (Exception e) {
                    throw new ResolveEndpointFailedException(uri, e);
                }
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    @Override
    public void addRegisterEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == endpoint) continue;
                this.endpoints.put(this.getEndpointKey(newEndpoint.getEndpointUri(), newEndpoint), newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
        return endpoint;
    }

    @Override
    public synchronized List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return new ArrayList<Route>(this.routes);
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
        throw new UnsupportedOperationException("Overriding existing routes is not supported yet, use addRoutes instead");
    }

    synchronized void removeRouteCollection(Collection<Route> routes) {
        if (this.routes != null) {
            this.routes.removeAll(routes);
        }
    }

    synchronized void addRouteCollection(Collection<Route> routes) throws Exception {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        if (routes != null) {
            this.routes.addAll(routes);
        }
    }

    @Override
    public void addRoutes(Routes builder) throws Exception {
        builder.setContext(this);
        List<Route> routeList = builder.getRouteList();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding routes from: " + builder + " routes: " + routeList));
        }
    }

    @Override
    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            routeDefinition.setCamelContext(this);
            this.removeRouteDefinition(routeDefinition);
        }
        this.routeDefinitions.addAll(routeDefinitions);
        if (this.shouldStartRoutes()) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    public boolean removeRouteDefinition(String key) {
        boolean answer = false;
        Iterator<RouteDefinition> iter = this.routeDefinitions.iterator();
        while (iter.hasNext()) {
            RouteDefinition route = iter.next();
            if (!route.idOrCreate().equals(key)) continue;
            iter.remove();
            answer = true;
        }
        return answer;
    }

    @Override
    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.routeDefinitions.removeAll(routeDefinitions);
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        String key = routeDefinition.idOrCreate();
        this.stopRoute(key);
        this.removeRouteDefinition(key);
    }

    @Override
    public ServiceStatus getRouteStatus(RouteDefinition route) {
        return this.getRouteStatus(route.idOrCreate());
    }

    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    @Override
    public void startRoute(RouteDefinition route) throws Exception {
        ArrayList<Route> routes = new ArrayList<Route>();
        List<RouteContext> routeContexts = route.addRoutes(this, routes);
        RouteService routeService = new RouteService(this, route, routeContexts, routes);
        this.startRouteService(routeService);
    }

    @Override
    public void stopRoute(RouteDefinition route) throws Exception {
        this.stopRoute(route.idOrCreate());
    }

    public synchronized void stopRoute(String key) throws Exception {
        RouteService routeService = this.routeServices.remove(key);
        if (routeService != null) {
            routeService.stop();
        }
    }

    public void addService(Object object) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            this.getLifecycleStrategy().onServiceAdd(this, service);
            service.start();
            this.servicesToClose.add(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language resolveLanguage(String language) {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)((Object)answer)).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, this);
            if (answer != null) {
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    @Override
    public ExchangeConverter getExchangeConverter() {
        if (this.exchangeConverter == null) {
            this.exchangeConverter = this.createExchangeConverter();
        }
        return this.exchangeConverter;
    }

    public void setExchangeConverter(ExchangeConverter exchangeConverter) {
        this.exchangeConverter = exchangeConverter;
    }

    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = this.createTypeConverter();
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            if (this.typeConverter == null) {
                this.getTypeConverter();
            }
            if (this.typeConverter instanceof DefaultTypeConverter) {
                this.typeConverterRegistry = (DefaultTypeConverter)this.typeConverter;
            }
        }
        return this.typeConverterRegistry;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = typeConverterRegistry;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
        }
        return this.registry;
    }

    public void setJndiContext(Context jndiContext) {
        this.setRegistry(new JndiRegistry(jndiContext));
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public LifecycleStrategy getLifecycleStrategy() {
        return this.lifecycleStrategy;
    }

    public void setLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategy = lifecycleStrategy;
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    public boolean isStreamCacheEnabled() {
        Boolean value = this.getStreamCaching();
        if (value != null) {
            return value;
        }
        return SystemHelper.isSystemProperty("camel.streamCache");
    }

    public Boolean getStreamCaching() {
        return this.streamCache;
    }

    public void setStreamCaching(Boolean trace) {
        this.streamCache = trace;
    }

    public boolean isHandleFaultEnabled() {
        Boolean value = this.getHandleFault();
        if (value != null) {
            return value;
        }
        return SystemHelper.isSystemProperty("camel.handleFault");
    }

    public Boolean getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    public boolean isTraceEnabled() {
        Boolean value = this.getTrace();
        if (value != null) {
            return value;
        }
        return SystemHelper.isSystemProperty("camel.trace");
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public long isDelayEnabled() {
        Long value = this.getDelay();
        if (value != null) {
            return value;
        }
        String prop = SystemHelper.getSystemProperty("camel.delay");
        return prop != null ? Long.getLong(prop) : 0L;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    @Override
    public ProducerTemplate createProducerTemplate() {
        return new DefaultProducerTemplate(this);
    }

    @Override
    public ConsumerTemplate createConsumerTemplate() {
        return new DefaultConsumerTemplate(this);
    }

    @Override
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @Override
    public void setProducerServicePool(ServicePool<Endpoint, Producer> producerServicePool) {
        this.producerServicePool = producerServicePool;
    }

    @Override
    public ServicePool<Endpoint, Producer> getProducerServicePool() {
        return this.producerServicePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        super.start();
        DefaultCamelContext defaultCamelContext = this;
        synchronized (defaultCamelContext) {
            for (RouteService routeService : this.routeServices.values()) {
                routeService.start();
            }
        }
        this.producerServicePool.stop();
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") started"));
    }

    @Override
    protected void doStart() throws Exception {
        block10: {
            long delayInMillis;
            LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is starting"));
            this.producerServicePool.start();
            if (this.isStreamCacheEnabled() && StreamCaching.getStreamCaching(this) == null) {
                LOG.debug((Object)"StreamCaching is enabled");
                this.addInterceptStrategy(new StreamCaching());
            }
            if (this.isTraceEnabled() && Tracer.getTracer(this) == null) {
                Tracer tracer = new Tracer();
                TraceFormatter formatter = this.getRegistry().lookup("traceFormatter", TraceFormatter.class);
                if (formatter != null) {
                    tracer.setFormatter(formatter);
                }
                LOG.debug((Object)"Tracing is enabled");
                this.addInterceptStrategy(tracer);
            }
            if ((delayInMillis = this.isDelayEnabled()) > 0L && Delayer.getDelayer(this) == null) {
                LOG.debug((Object)("Delayer is enabled with: " + delayInMillis + " ms."));
                this.addInterceptStrategy(new Delayer(delayInMillis));
            }
            if (this.isHandleFaultEnabled() && HandleFault.getHandleFault(this) == null) {
                LOG.debug((Object)"HandleFault is enabled");
                this.addInterceptStrategy(new HandleFault());
            }
            try {
                this.lifecycleStrategy.onContextStart(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot start lifecycleStrategy: " + this.lifecycleStrategy + ". Cause: " + e.getMessage()));
                if (!(this.lifecycleStrategy instanceof InstrumentationLifecycleStrategy)) break block10;
                LOG.warn((Object)"Will fallback to use default (non JMX) lifecycle strategy");
                this.lifecycleStrategy = new DefaultLifecycleStrategy();
                this.lifecycleStrategy.onContextStart(this);
            }
        }
        this.forceLazyInitialization();
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.startServices(component);
            }
        }
        if (!this.routeDefinitionInitiated) {
            this.startRouteDefinitions(this.routeDefinitions);
            this.routeDefinitionInitiated = true;
        }
    }

    protected void startRouteDefinitions(Collection<RouteDefinition> list) throws Exception {
        if (list != null) {
            for (RouteDefinition route : list) {
                this.startRoute(route);
            }
        }
    }

    protected synchronized void startRouteService(RouteService routeService) throws Exception {
        String key = routeService.getId();
        this.stopRoute(key);
        this.routeServices.put(key, routeService);
        if (this.shouldStartRoutes()) {
            routeService.start();
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is stopping"));
        ServiceHelper.stopServices(this.routeServices.values());
        ServiceHelper.stopServices(this.servicesToClose);
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.stopServices(component);
            }
        }
        this.servicesToClose.clear();
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") stopped"));
    }

    protected void forceLazyInitialization() {
        this.getExchangeConverter();
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverter();
    }

    protected ExchangeConverter createExchangeConverter() {
        return new DefaultExchangeConverter();
    }

    protected TypeConverter createTypeConverter() {
        DefaultTypeConverter answer = new DefaultTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder());
        this.typeConverterRegistry = answer;
        return answer;
    }

    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new ReflectionInjector();
        }
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        return new JndiRegistry();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookup(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public FactoryFinder getDefaultFactoryFinder() {
        if (this.defaultFactoryFinder == null) {
            this.defaultFactoryFinder = this.factoryFinderResolver.resolveDefaultFactoryFinder(this.getClassResolver());
        }
        return this.defaultFactoryFinder;
    }

    @Override
    public void setFactoryFinderResolver(FactoryFinderResolver resolver) {
        this.factoryFinderResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinder getFactoryFinder(String path) throws NoFactoryAvailableException {
        Map<String, FactoryFinder> map = this.factories;
        synchronized (map) {
            FactoryFinder answer = this.factories.get(path);
            if (answer == null) {
                answer = this.factoryFinderResolver.resolveFactoryFinder(this.getClassResolver(), path);
                this.factories.put(path, answer);
            }
            return answer;
        }
    }

    @Override
    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public PackageScanClassResolver getPackageScanClassResolver() {
        return this.packageScanClassResolver;
    }

    @Override
    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = packageScanClassResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComponentNames() {
        Map<String, Component> map = this.components;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.components.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLanguageNames() {
        Map<String, Language> map = this.languages;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.languages.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    protected synchronized String getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint.isSingleton()) {
            return uri;
        }
        int counter = 0;
        while (true) {
            String key;
            String string = key = counter > 0 ? uri + ":" + counter : uri;
            if (!this.endpoints.containsKey(key)) {
                return key;
            }
            ++counter;
        }
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }
}

