/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchange
implements Exchange {
    private static final UuidGenerator DEFAULT_ID_GENERATOR = new UuidGenerator();
    protected final CamelContext context;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Message fault;
    private Exception exception;
    private String exchangeId;
    private UnitOfWork unitOfWork;
    private ExchangePattern pattern;
    private Endpoint fromEndpoint;
    private List<Synchronization> onCompletions;

    public DefaultExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    public DefaultExchange(Exchange parent) {
        this(parent.getContext(), parent.getPattern());
        this.unitOfWork = parent.getUnitOfWork();
        this.fromEndpoint = parent.getFromEndpoint();
    }

    public DefaultExchange(Endpoint fromEndpoint) {
        this(fromEndpoint, ExchangePattern.InOnly);
    }

    public DefaultExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this.context = fromEndpoint.getCamelContext();
        this.fromEndpoint = fromEndpoint;
        this.pattern = pattern;
    }

    public String toString() {
        return "Exchange[" + this.in + "]";
    }

    @Override
    public Exchange copy() {
        Exchange exchange = this.newInstance();
        exchange.copyFrom(this);
        return exchange;
    }

    @Override
    public Exchange newCopy(boolean handoverOnCompletion) {
        Exchange copy = this.copy();
        copy.setUnitOfWork(null);
        if (handoverOnCompletion && this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(copy);
        }
        return copy;
    }

    @Override
    public void copyFrom(Exchange exchange) {
        if (exchange == this) {
            return;
        }
        this.setProperties(DefaultExchange.safeCopy(exchange.getProperties()));
        DefaultExchange.safeCopy(this.getIn(), exchange.getIn());
        if (exchange.hasOut()) {
            DefaultExchange.safeCopy(this.getOut(), exchange.getOut());
        }
        if (exchange.hasFault()) {
            DefaultExchange.safeCopy(this.getFault(), exchange.getFault());
        }
        this.setException(exchange.getException());
        this.unitOfWork = exchange.getUnitOfWork();
        this.pattern = exchange.getPattern();
        this.setFromEndpoint(exchange.getFromEndpoint());
    }

    private static void safeCopy(Message message, Message that) {
        if (message != null) {
            message.copyFrom(that);
        }
    }

    private static Map<String, Object> safeCopy(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    @Override
    public Exchange newInstance() {
        return new DefaultExchange(this);
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value != null) {
            this.getProperties().put(name, value);
        } else if (name != null) {
            this.getProperties().remove(name);
        }
    }

    @Override
    public Object removeProperty(String name) {
        return this.getProperties().remove(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = this.createInMessage();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            this.out = this.createOutMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    @Override
    public boolean hasOut() {
        return this.out != null;
    }

    @Override
    public Message getOut(boolean lazyCreate) {
        if (this.out == null && lazyCreate) {
            this.out = this.createOutMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <T> T getException(Class<T> type) {
        if (this.exception == null) {
            return null;
        }
        Iterator<Throwable> it = ObjectHelper.createExceptionIterator(this.exception);
        while (it.hasNext()) {
            Throwable e = it.next();
            if (!type.isInstance(e)) continue;
            return type.cast(e);
        }
        return null;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    @Override
    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    @Override
    public Message getFault() {
        if (this.fault == null) {
            this.fault = this.createFaultMessage();
            this.configureMessage(this.fault);
        }
        return this.fault;
    }

    @Override
    public boolean hasFault() {
        return this.fault != null;
    }

    @Override
    public Message getFault(boolean lazyCreate) {
        if (this.fault == null && lazyCreate) {
            this.fault = this.createFaultMessage();
            this.configureMessage(this.fault);
        }
        return this.fault;
    }

    public void setFault(Message fault) {
        this.fault = fault;
        this.configureMessage(fault);
    }

    @Override
    public void removeFault() {
        this.fault = null;
    }

    @Override
    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    @Override
    public boolean isFailed() {
        Object faultBody;
        if (this.hasFault() && (faultBody = this.getFault().getBody()) != null) {
            return true;
        }
        return this.getException() != null;
    }

    @Override
    public boolean isTransacted() {
        Boolean transacted = this.getProperty("CamelTransacted", Boolean.class);
        return transacted != null && transacted != false;
    }

    @Override
    public boolean isRollbackOnly() {
        Boolean rollback = this.getProperty("CamelRollbackOnly", Boolean.class);
        return rollback != null && rollback != false;
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    @Override
    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                this.unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    @Override
    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    protected Message createInMessage() {
        return new DefaultMessage();
    }

    protected Message createOutMessage() {
        return new DefaultMessage();
    }

    protected Message createFaultMessage() {
        return new DefaultMessage();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
        }
    }

    protected String createExchangeId() {
        String answer = null;
        if (this.in != null) {
            answer = this.in.createExchangeId();
        }
        if (answer == null) {
            answer = DEFAULT_ID_GENERATOR.generateId();
        }
        return answer;
    }
}

