/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter
extends MulticastProcessor
implements Processor {
    private final Expression expression;

    public Splitter(Expression expression, Processor destination, AggregationStrategy aggregationStrategy) {
        this(expression, destination, aggregationStrategy, false, null, false);
    }

    public Splitter(Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming) {
        super(Collections.singleton(destination), aggregationStrategy, parallelProcessing, executorService, streaming);
        this.expression = expression;
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(destination, "destination");
    }

    @Override
    public String toString() {
        return "Splitter[on: " + this.expression + " to: " + this.getProcessors().iterator().next() + " aggregate: " + this.getAggregationStrategy() + "]";
    }

    @Override
    protected Iterable<MulticastProcessor.ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        Object value = this.expression.evaluate(exchange, Object.class);
        if (this.isStreaming()) {
            return this.createProcessorExchangePairsIterable(exchange, value);
        }
        return this.createProcessorExchangePairsList(exchange, value);
    }

    private Iterable<MulticastProcessor.ProcessorExchangePair> createProcessorExchangePairsIterable(final Exchange exchange, Object value) {
        final Iterator iterator = ObjectHelper.createIterator(value);
        return new Iterable(){

            public Iterator iterator() {
                return new Iterator(){

                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    public Object next() {
                        Object part = iterator.next();
                        Exchange newExchange = exchange.copy();
                        if (part instanceof Message) {
                            newExchange.setIn((Message)part);
                        } else {
                            Message in = newExchange.getIn();
                            in.setBody(part);
                        }
                        return new MulticastProcessor.ProcessorExchangePair(Splitter.this.getProcessors().iterator().next(), newExchange);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not supported by this iterator");
                    }
                };
            }
        };
    }

    private Iterable<MulticastProcessor.ProcessorExchangePair> createProcessorExchangePairsList(Exchange exchange, Object value) {
        Integer collectionSize = CollectionHelper.size(value);
        ArrayList<MulticastProcessor.ProcessorExchangePair> result = collectionSize != null ? new ArrayList(collectionSize) : new ArrayList<MulticastProcessor.ProcessorExchangePair>();
        Iterator iter = ObjectHelper.createIterator(value);
        while (iter.hasNext()) {
            Object part = iter.next();
            Exchange newExchange = exchange.copy();
            if (part instanceof Message) {
                newExchange.setIn((Message)part);
            } else {
                Message in = newExchange.getIn();
                in.setBody(part);
            }
            result.add(new MulticastProcessor.ProcessorExchangePair(this.getProcessors().iterator().next(), newExchange));
        }
        return result;
    }

    @Override
    protected void updateNewExchange(Exchange exchange, int index, Iterable<MulticastProcessor.ProcessorExchangePair> allPairs) {
        super.updateNewExchange(exchange, index, allPairs);
        exchange.getIn().setHeader("CamelSplitIndex", index);
        if (allPairs instanceof Collection) {
            exchange.getIn().setHeader("CamelSplitSize", ((Collection)allPairs).size());
        }
    }

    public Expression getExpression() {
        return this.expression;
    }
}

