/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsProcessor
extends DelegateProcessor
implements Processor {
    protected static final int DEFAULT_THREADPOOL_SIZE = 5;
    protected ExecutorService executorService;
    protected WaitForTaskToComplete waitForTaskToComplete;

    public ThreadsProcessor(Processor output, ExecutorService executorService, WaitForTaskToComplete waitForTaskToComplete) {
        super(output);
        this.executorService = executorService;
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Processor output = this.getProcessor();
        if (output == null) {
            return;
        }
        Exchange copy = exchange.newCopy(true);
        Callable<Exchange> task = this.createTask(output, copy);
        Future<Exchange> future = this.getExecutorService().submit(task);
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getIn().getHeader("CamelAsyncWait") != null) {
            wait = exchange.getIn().getHeader("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always) {
            Exchange response = future.get();
            ExchangeHelper.copyResults(exchange, response);
        } else if (wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable(exchange)) {
            Exchange response = future.get();
            ExchangeHelper.copyResults(exchange, response);
        } else {
            exchange.getOut().setBody(future);
        }
    }

    protected Callable<Exchange> createTask(final Processor output, final Exchange copy) {
        return new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                output.process(copy);
                return copy;
            }
        };
    }

    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    protected ExecutorService createExecutorService() {
        return ExecutorServiceHelper.newScheduledThreadPool(5, "AsyncProcessor", true);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

