/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceEventExchange;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceInterceptor
extends DelegateProcessor
implements ExchangeFormatter {
    private static final transient Log LOG = LogFactory.getLog(TraceInterceptor.class);
    private static final String JPA_TRACE_EVENT_MESSAGE = "org.apache.camel.processor.interceptor.JpaTraceEventMessage";
    private static final String TRACE_EVENT = "CamelTraceEvent";
    private Logger logger;
    private Producer traceEventProducer;
    private final ProcessorDefinition node;
    private final Tracer tracer;
    private TraceFormatter formatter;
    private Class jpaTraceEventMessageClass;

    public TraceInterceptor(ProcessorDefinition node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogName() != null ? new Logger(LogFactory.getLog((String)tracer.getLogName()), this) : new Logger(LogFactory.getLog(TraceInterceptor.class), this);
        if (tracer.getLogLevel() != null) {
            this.logger.setLevel(tracer.getLogLevel());
        }
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
    }

    public TraceInterceptor(ProcessorDefinition node, Processor target, Tracer tracer) {
        this(node, target, null, tracer);
    }

    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange instanceof TraceEventExchange || exchange.getProperty(TRACE_EVENT, Boolean.class) != null) {
            super.process(exchange);
            return;
        }
        boolean shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
        try {
            if (shouldLog) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
                if (exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
                    TraceableUnitOfWork tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
                    tuow.addInterceptedNode(this.node);
                }
            }
            super.proceed(exchange);
            if (shouldLog && this.tracer.isTraceOutExchanges()) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
        catch (Exception e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            throw e;
        }
    }

    public Object format(Exchange exchange) {
        return this.formatter.format(this, this.getNode(), exchange);
    }

    public ProcessorDefinition getNode() {
        return this.node;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceExchange(Exchange exchange) throws Exception {
        if (this.tracer.getDestination() != null || this.tracer.getDestinationUri() != null) {
            TraceEventExchange event = new TraceEventExchange(exchange);
            Date timestamp = new Date();
            event.setNodeId(this.node.getId());
            event.setTimestamp(timestamp);
            event.setTracedExchange(exchange);
            DefaultTraceEventMessage msg = new DefaultTraceEventMessage(timestamp, this.node, exchange);
            if (this.tracer.isUseJpa()) {
                LOG.trace((Object)"Using class: org.apache.camel.processor.interceptor.JpaTraceEventMessage for tracing event messages");
                TraceInterceptor traceInterceptor = this;
                synchronized (traceInterceptor) {
                    if (this.jpaTraceEventMessageClass == null) {
                        this.jpaTraceEventMessageClass = exchange.getContext().getClassResolver().resolveClass(JPA_TRACE_EVENT_MESSAGE);
                        if (this.jpaTraceEventMessageClass == null) {
                            throw new IllegalArgumentException("Cannot find class: org.apache.camel.processor.interceptor.JpaTraceEventMessage. Make sure camel-jpa.jar is in the classpath.");
                        }
                    }
                }
                Object jpa = ObjectHelper.newInstance(this.jpaTraceEventMessageClass);
                HashMap options = new HashMap();
                IntrospectionSupport.getProperties(msg, options, null);
                IntrospectionSupport.setProperties(jpa, options);
                IntrospectionSupport.setProperty(jpa, "timestamp", msg.getTimestamp());
                event.getIn().setBody(jpa);
            } else {
                event.getIn().setBody(msg);
            }
            event.setProperty(TRACE_EVENT, Boolean.TRUE);
            try {
                this.getTraceEventProducer(exchange).process(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing TraceEventExchange (original Exchange will be continued): " + event), (Throwable)e);
            }
        }
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            this.logger.process(exchange, throwable);
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.tracer.isEnabled() && (this.tracer.getTraceFilter() == null || this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    public boolean shouldTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    protected boolean shouldLogNode(ProcessorDefinition node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy);
    }

    private synchronized Producer getTraceEventProducer(Exchange exchange) throws Exception {
        if (this.traceEventProducer == null) {
            Endpoint endpoint = this.tracer.getDestination() != null ? this.tracer.getDestination() : exchange.getContext().getEndpoint(this.tracer.getDestinationUri());
            this.traceEventProducer = endpoint.createProducer();
            ServiceHelper.startService(this.traceEventProducer);
        }
        return this.traceEventProducer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.traceEventProducer = null;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.traceEventProducer != null) {
            ServiceHelper.stopService(this.traceEventProducer);
        }
    }
}

