/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.xml.sax.SAXException;

public class ValidatingProcessor
implements Processor {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Schema schema;
    private Source schemaSource;
    private SchemaFactory schemaFactory;
    private URL schemaUrl;
    private File schemaFile;
    private ValidatorErrorHandler errorHandler = new DefaultValidationErrorHandler();

    public void process(Exchange exchange) throws Exception {
        Schema schema = this.getSchema();
        Validator validator = schema.newValidator();
        Source source = exchange.getIn().getBody(DOMSource.class);
        if (source == null) {
            throw new NoXmlBodyValidationException(exchange);
        }
        ValidatorErrorHandler handler = (ValidatorErrorHandler)this.errorHandler.getClass().newInstance();
        validator.setErrorHandler(handler);
        DOMResult result = new DOMResult();
        validator.validate(source, result);
        handler.handleErrors(exchange, schema, result);
    }

    public void loadSchema() throws Exception {
        this.schema = this.createSchema();
    }

    public Schema getSchema() throws IOException, SAXException {
        if (this.schema == null) {
            this.schema = this.createSchema();
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() throws IOException {
        if (this.schemaSource == null) {
            this.schemaSource = this.createSchemaSource();
        }
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = this.createSchemaFactory();
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public ValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected SchemaFactory createSchemaFactory() {
        return SchemaFactory.newInstance(this.schemaLanguage);
    }

    protected Source createSchemaSource() throws IOException {
        throw new IllegalArgumentException("You must specify either a schema, schemaFile, schemaSource or schemaUrl property");
    }

    protected Schema createSchema() throws SAXException, IOException {
        SchemaFactory factory = this.getSchemaFactory();
        URL url = this.getSchemaUrl();
        if (url != null) {
            return factory.newSchema(url);
        }
        File file = this.getSchemaFile();
        if (file != null) {
            return factory.newSchema(file);
        }
        return factory.newSchema(this.getSchemaSource());
    }
}

