/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spring.spi.TransactedRuntimeCamelException;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends ErrorHandlerSupport {
    private static final transient Log LOG = LogFactory.getLog(TransactionErrorHandler.class);
    private final TransactionTemplate transactionTemplate;
    private Processor output;

    public TransactionErrorHandler(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public TransactionErrorHandler(TransactionTemplate transactionTemplate, Processor output, ExceptionPolicyStrategy exceptionPolicy) {
        this.transactionTemplate = transactionTemplate;
        this.setOutput(output);
        this.setExceptionPolicy(exceptionPolicy);
    }

    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + this.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getOutput() + "]";
    }

    public void process(final Exchange exchange) {
        if (this.output == null) {
            return;
        }
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                boolean activeTx = TransactionSynchronizationManager.isActualTransactionActive();
                if (!activeTx) {
                    boolean bl = activeTx = status.isNewTransaction() && !status.isCompleted();
                    if (!activeTx && DefaultTransactionStatus.class.isAssignableFrom(status.getClass())) {
                        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)DefaultTransactionStatus.class.cast(status);
                        boolean bl2 = activeTx = defStatus.hasTransaction() && !status.isCompleted();
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Is actual transaction active: " + activeTx));
                }
                if (activeTx) {
                    exchange.setProperty("CamelTransacted", (Object)Boolean.TRUE);
                }
                try {
                    TransactionErrorHandler.this.output.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                if (exchange.getException() != null) {
                    boolean handled = false;
                    if (exchange.getException() instanceof TransactedRuntimeCamelException) {
                        TransactedRuntimeCamelException trce = (TransactedRuntimeCamelException)((Object)exchange.getException(TransactedRuntimeCamelException.class));
                        handled = trce.isHandled();
                    }
                    if (!handled) {
                        TransactionErrorHandler.this.handleException(exchange);
                    }
                }
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    TransactedRuntimeCamelException rce = TransactionErrorHandler.this.wrapTransactedRuntimeException(exchange.getException());
                    if (activeTx) {
                        status.setRollbackOnly();
                        if (LOG.isDebugEnabled()) {
                            if (rce != null) {
                                LOG.debug((Object)("Setting transaction to rollbackOnly due to exception being thrown: " + rce.getMessage()));
                            } else {
                                LOG.debug((Object)"Setting transaction to rollbackOnly as Exchange was marked as rollback only");
                            }
                        }
                    }
                    if (rce != null) {
                        throw rce;
                    }
                }
            }
        });
    }

    protected TransactedRuntimeCamelException wrapTransactedRuntimeException(Exception exception) {
        if (exception instanceof TransactedRuntimeCamelException) {
            return (TransactedRuntimeCamelException)((Object)exception);
        }
        return new TransactedRuntimeCamelException(exception, true);
    }

    protected void handleException(Exchange exchange) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", (Object)e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            Predicate handledPredicate = exceptionPolicy.getHandledPolicy();
            Processor processor = exceptionPolicy.getErrorHandler();
            this.prepareExchangeBeforeOnException(exchange);
            if (processor != null) {
                this.deliverToFaultProcessor(exchange, processor);
            }
            this.prepareExchangeAfterOnException(exchange, handledPredicate);
        }
    }

    private void deliverToFaultProcessor(Exchange exchange, Processor faultProcessor) {
        try {
            faultProcessor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    private void prepareExchangeBeforeOnException(Exchange exchange) {
        if (exchange.getException() != null) {
            exchange.setException(null);
        }
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache((Message)exchange.getIn());
    }

    private void prepareExchangeAfterOnException(Exchange exchange, Predicate handledPredicate) {
        if (handledPredicate == null || !handledPredicate.matches(exchange)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("This exchange is not handled so its marked as rollback only: " + exchange));
            }
            exchange.setException((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class));
            exchange.setProperty("CamelRollbackOnly", (Object)Boolean.TRUE);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("This exchange is handled so its marked as not failed: " + exchange));
            }
            exchange.setProperty("CamelExceptionHandled", (Object)Boolean.TRUE);
        }
    }

    protected String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices((Object[])new Object[]{this.output});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.output});
    }

    public Processor getOutput() {
        return this.output;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }
}

