/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import javax.jms.JMSException;
import javax.jms.Message;

public final class JmsMessageHelper {
    private JmsMessageHelper() {
    }

    public static Object removeJmsProperty(Message jmsMessage, String name) throws JMSException {
        if (!jmsMessage.propertyExists(name)) {
            return null;
        }
        String answer = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (name.equals(key)) {
                answer = key;
                continue;
            }
            map.put(key, jmsMessage.getObjectProperty(key));
        }
        jmsMessage.clearProperties();
        for (String key : map.keySet()) {
            jmsMessage.setObjectProperty(key, map.get(key));
        }
        return answer;
    }
}

