/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeadLetterChannelBuilder
extends ErrorHandlerBuilderSupport {
    private Logger logger = new Logger(LogFactory.getLog(DeadLetterChannel.class), LoggingLevel.ERROR);
    private ExceptionPolicyStrategy exceptionPolicyStrategy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();
    private RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
    private Processor onRedelivery;
    private Processor failureProcessor;
    private Endpoint deadLetter;
    private String deadLetterUri;
    private Predicate handledPolicy;
    private boolean useOriginalBody;

    public DeadLetterChannelBuilder() {
        this("log:org.apache.camel.DeadLetterChannel?level=error");
    }

    public DeadLetterChannelBuilder(Endpoint deadLetter) {
        this.setDeadLetter(deadLetter);
    }

    public DeadLetterChannelBuilder(String uri) {
        this.setDeadLetterUri(uri);
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        DeadLetterChannel answer = new DeadLetterChannel(processor, this.getFailureProcessor(), this.deadLetterUri, this.onRedelivery, this.getRedeliveryPolicy(), this.getLogger(), this.getExceptionPolicyStrategy(), this.getHandledPolicy(), this.isUseOriginalBody());
        this.configure(answer);
        return answer;
    }

    public boolean supportTransacted() {
        return false;
    }

    public DeadLetterChannelBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public DeadLetterChannelBuilder collisionAvoidancePercent(short collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public DeadLetterChannelBuilder delay(long delay) {
        this.getRedeliveryPolicy().delay(delay);
        return this;
    }

    public DeadLetterChannelBuilder delayPattern(String delayPattern) {
        this.getRedeliveryPolicy().delayPattern(delayPattern);
        return this;
    }

    public DeadLetterChannelBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public DeadLetterChannelBuilder disableRedelivery() {
        this.getRedeliveryPolicy().maximumRedeliveries(0);
        return this;
    }

    public DeadLetterChannelBuilder maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public DeadLetterChannelBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public DeadLetterChannelBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public DeadLetterChannelBuilder retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getRedeliveryPolicy().setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public DeadLetterChannelBuilder retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getRedeliveryPolicy().setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public DeadLetterChannelBuilder logStackTrace(boolean logStackTrace) {
        this.getRedeliveryPolicy().setLogStackTrace(logStackTrace);
        return this;
    }

    public DeadLetterChannelBuilder handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    public DeadLetterChannelBuilder handled(Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    public DeadLetterChannelBuilder handled(Expression handled) {
        this.setHandledPolicy(PredicateBuilder.toPredicate(handled));
        return this;
    }

    public DeadLetterChannelBuilder logger(Logger logger) {
        this.setLogger(logger);
        return this;
    }

    public DeadLetterChannelBuilder loggingLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
        return this;
    }

    public DeadLetterChannelBuilder log(Log log) {
        this.getLogger().setLog(log);
        return this;
    }

    public DeadLetterChannelBuilder log(String log) {
        return this.log(LogFactory.getLog((String)log));
    }

    public DeadLetterChannelBuilder log(Class log) {
        return this.log(LogFactory.getLog((Class)log));
    }

    public DeadLetterChannelBuilder exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }

    public DeadLetterChannelBuilder onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public DeadLetterChannelBuilder useOriginalBody() {
        this.setUseOriginalBody(true);
        return this;
    }

    public Processor getFailureProcessor() {
        if (this.failureProcessor == null) {
            this.failureProcessor = this.deadLetter != null ? new SendProcessor(this.deadLetter) : new RecipientList(new Expression(){

                public Object evaluate(Exchange exchange) {
                    return DeadLetterChannelBuilder.this.deadLetterUri;
                }

                @Override
                public <T> T evaluate(Exchange exchange, Class<T> type) {
                    return exchange.getContext().getTypeConverter().convertTo(type, DeadLetterChannelBuilder.this.deadLetterUri);
                }
            });
        }
        return this.failureProcessor;
    }

    public void setFailureProcessor(Processor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetter = null;
        this.deadLetterUri = deadLetterUri;
    }

    public Endpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void setDeadLetter(Endpoint deadLetter) {
        this.deadLetter = deadLetter;
        this.deadLetterUri = deadLetter.getEndpointUri();
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandledPolicy(Predicate handled) {
        this.handledPolicy = handled;
    }

    public void setHandled(boolean handled) {
        this.handled(handled);
    }

    public boolean isUseOriginalBody() {
        return this.useOriginalBody;
    }

    public void setUseOriginalBody(boolean useOriginalBody) {
        this.useOriginalBody = useOriginalBody;
    }

    public String toString() {
        return "DeadLetterChannelBuilder(" + this.deadLetterUri + ")";
    }
}

