/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.IOException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategySupport;
import org.apache.camel.component.file.strategy.GenericFileRenamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRenameProcessStrategy<T>
extends GenericFileProcessStrategySupport<T> {
    private GenericFileRenamer<T> beginRenamer;
    private GenericFileRenamer<T> commitRenamer;

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, GenericFileExchange<T> exchange, GenericFile<T> file) throws Exception {
        boolean result = super.begin(operations, endpoint, exchange, file);
        if (!result) {
            return false;
        }
        if (this.beginRenamer != null) {
            GenericFile<T> newName = this.beginRenamer.renameFile(exchange, file);
            GenericFile<T> to = this.renameFile(operations, file, newName);
            exchange.setGenericFile(to);
        }
        return true;
    }

    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, GenericFileExchange<T> exchange, GenericFile<T> file) throws Exception {
        super.commit(operations, endpoint, exchange, file);
        if (this.commitRenamer != null) {
            GenericFile<T> newName = this.commitRenamer.renameFile(exchange, file);
            this.renameFile(operations, file, newName);
        }
    }

    private GenericFile<T> renameFile(GenericFileOperations<T> operations, GenericFile<T> from, GenericFile<T> to) throws IOException {
        boolean renamed;
        try {
            operations.deleteFile(to.getAbsoluteFilePath());
        }
        catch (GenericFileOperationFailedException e) {
            // empty catch block
        }
        boolean mkdir = operations.buildDirectory(to.getParent(), to.isAbsolute());
        if (!mkdir) {
            throw new GenericFileOperationFailedException("Cannot create directory: " + to.getParent() + " (could be because of denied permissions)");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Renaming file: " + from + " to: " + to));
        }
        if (!(renamed = operations.renameFile(from.getAbsoluteFilePath(), to.getAbsoluteFilePath()))) {
            throw new GenericFileOperationFailedException("Cannot rename file: " + from + " to: " + to);
        }
        return to;
    }

    public GenericFileRenamer<T> getBeginRenamer() {
        return this.beginRenamer;
    }

    public void setBeginRenamer(GenericFileRenamer<T> beginRenamer) {
        this.beginRenamer = beginRenamer;
    }

    public GenericFileRenamer<T> getCommitRenamer() {
        return this.commitRenamer;
    }

    public void setCommitRenamer(GenericFileRenamer<T> commitRenamer) {
        this.commitRenamer = commitRenamer;
    }
}

