/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.impl.AnnotatedWithPackageScanFilter;
import org.apache.camel.impl.AssignableToPackageScanFilter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackageScanClassResolver
implements PackageScanClassResolver {
    protected static final transient Log LOG = LogFactory.getLog(DefaultPackageScanClassResolver.class);
    private Set<ClassLoader> classLoaders;

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        this.getClassLoaders().add(classLoader);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("The thread context class loader: " + ccl + "  is used to load the class"));
                }
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(DefaultPackageScanClassResolver.class.getClassLoader());
        }
        return this.classLoaders;
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public Set<Class> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for annotations of " + annotation.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        AnnotatedWithPackageScanFilter test = new AnnotatedWithPackageScanFilter(annotation, true);
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    @Override
    public Set<Class> findAnnotated(Set<Class<? extends Annotation>> annotations, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for annotations of " + annotations + " in packages: " + Arrays.asList(packageNames)));
        }
        AnnotatedWithAnyPackageScanFilter test = new AnnotatedWithAnyPackageScanFilter(annotations, true);
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    @Override
    public Set<Class> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        AssignableToPackageScanFilter test = new AssignableToPackageScanFilter(parent);
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    @Override
    public Set<Class> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + classes));
        }
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader, classes);
        }
    }

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class> classes) {
        Enumeration<URL> urls;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName()));
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                LOG.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Could not read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                File file;
                url = urls.nextElement();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("URL from classloader: " + url));
                }
                String urlPath = url.getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Decoded urlPath: " + urlPath));
                }
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    LOG.trace((Object)"It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Scanning for classes in [" + urlPath + "] matching criteria: " + test));
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Loading from directory: " + file));
                    }
                    this.loadImplementationsInDirectory(test, packageName, file, classes);
                    continue;
                }
                if (urlPath.startsWith("http:")) {
                    LOG.debug((Object)"The current jar is accessed via http");
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    stream = new FileInputStream(file);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading from jar: " + file));
                }
                this.loadImplementationsInJar(test, packageName, stream, urlPath, classes);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Could not read entries in url: " + url), (Throwable)ioe);
            }
        }
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Getting resource URL for package: " + packageName + " with classloader: " + loader));
        }
        return loader.getResources(packageName);
    }

    private void loadImplementationsInDirectory(PackageScanFilter test, String parent, File location, Set<Class> classes) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass, classes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplementationsInJar(PackageScanFilter test, String parent, InputStream stream, String urlPath, Set<Class> classes) {
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(test, name, classes);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not search jar file '" + urlPath + "' for classes matching criteria: " + test + " due to an IOException: " + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            ObjectHelper.close(jarStream, urlPath, LOG);
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class> classes) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Set<ClassLoader> set = this.getClassLoaders();
            boolean found = false;
            for (ClassLoader classLoader : set) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Testing for class " + externalName + " matches criteria [" + test + "] using ClassLoader:" + classLoader));
                }
                try {
                    Class<?> type = classLoader.loadClass(externalName);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Loaded the class: " + type + " in classloader: " + classLoader));
                    }
                    if (test.matches(type)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Found class: " + type + " which matches the filter in classloader: " + classLoader));
                        }
                        classes.add(type);
                    }
                    found = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    LOG.debug((Object)("Could not find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    LOG.debug((Object)("Could not find the class defintion '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                }
            }
            if (!found) {
                LOG.warn((Object)("Could not find class '" + fqn + "' in any classloaders: " + set));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not examine class '" + fqn + "' due to a " + e.getClass().getName() + " with message: " + e.getMessage()), (Throwable)e);
        }
    }
}

