/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.EndpointHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutesDefinition
extends OptionalIdentifiedType<RoutesDefinition>
implements RouteContainer {
    @XmlElementRef
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlTransient
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlTransient
    private List<InterceptSendToEndpointDefinition> interceptSendTos = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlTransient
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlTransient
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ErrorHandlerBuilder errorHandlerBuilder;

    public String toString() {
        return "Routes: " + this.routes;
    }

    @Override
    public String getShortName() {
        return "routes";
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendTos() {
        return this.interceptSendTos;
    }

    public void setInterceptSendTos(List<InterceptSendToEndpointDefinition> interceptSendTos) {
        this.interceptSendTos = interceptSendTos;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    public RouteDefinition route() {
        RouteDefinition route = this.createRoute();
        return this.route(route);
    }

    public RouteDefinition from(String uri) {
        RouteDefinition route = this.createRoute();
        route.from(uri);
        return this.route(route);
    }

    public RouteDefinition from(Endpoint endpoint) {
        RouteDefinition route = this.createRoute();
        route.from(endpoint);
        return this.route(route);
    }

    public RouteDefinition from(String ... uris) {
        RouteDefinition route = this.createRoute();
        route.from(uris);
        return this.route(route);
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        RouteDefinition route = this.createRoute();
        route.from(endpoints);
        return this.route(route);
    }

    public RouteDefinition route(RouteDefinition route) {
        route.setCamelContext(this.getCamelContext());
        for (InterceptDefinition interceptDefinition : this.getIntercepts()) {
            route.getOutputs().add(0, interceptDefinition);
        }
        for (InterceptFromDefinition interceptFromDefinition : this.getInterceptFroms()) {
            boolean match = true;
            if (interceptFromDefinition.getUri() != null) {
                match = false;
                for (FromDefinition input : route.getInputs()) {
                    if (!EndpointHelper.matchEndpoint(input.getUri(), interceptFromDefinition.getUri())) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            route.getOutputs().add(0, interceptFromDefinition);
        }
        for (InterceptSendToEndpointDefinition interceptSendToEndpointDefinition : this.getInterceptSendTos()) {
            route.getOutputs().add(0, interceptSendToEndpointDefinition);
        }
        route.getOutputs().addAll(this.getOnCompletions());
        route.getOutputs().addAll(0, this.getOnExceptions());
        this.getRoutes().add(route);
        return route;
    }

    public InterceptDefinition intercept() {
        InterceptDefinition answer = new InterceptDefinition();
        this.getIntercepts().add(answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom() {
        InterceptFromDefinition answer = new InterceptFromDefinition();
        this.getInterceptFroms().add(answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        InterceptFromDefinition answer = new InterceptFromDefinition(uri);
        this.getInterceptFroms().add(answer);
        return answer;
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        InterceptSendToEndpointDefinition answer = new InterceptSendToEndpointDefinition(uri);
        this.getInterceptSendTos().add(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class exception) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exception);
        this.getOnExceptions().add(answer);
        return answer;
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        this.getOnCompletions().add(answer);
        return answer;
    }

    protected RouteDefinition createRoute() {
        RouteDefinition route = new RouteDefinition();
        ErrorHandlerBuilder handler = this.getErrorHandlerBuilder();
        if (handler != null) {
            route.setErrorHandlerBuilderIfNull(handler);
        }
        return route;
    }
}

