/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoopProcessor
extends DelegateProcessor {
    private static final Log LOG = LogFactory.getLog(LoopProcessor.class);
    private final Expression expression;

    public LoopProcessor(Expression expression, Processor processor) {
        super(processor);
        this.expression = expression;
    }

    public void process(Exchange exchange) throws Exception {
        String text = this.expression.evaluate(exchange, String.class);
        int count = ExchangeHelper.convertToMandatoryType(exchange, Integer.class, text);
        exchange.setProperty("CamelLoopSize", count);
        for (int i = 0; i < count; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("LoopProcessor: iteration #" + i));
            }
            exchange.setProperty("CamelLoopIndex", i);
            super.process(exchange);
        }
    }

    public String toString() {
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }

    public Expression getExpression() {
        return this.expression;
    }
}

