/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnCompletionProcessor
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(OnCompletionProcessor.class);
    private ExecutorService executorService;
    private Processor processor;
    private boolean onComplete;
    private boolean onFailure;
    private Predicate onWhen;

    public OnCompletionProcessor(Processor processor, boolean onComplete, boolean onFailure, Predicate onWhen) {
        this.processor = processor;
        this.onComplete = onComplete;
        this.onFailure = onFailure;
        this.onWhen = onWhen;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        ServiceHelper.stopService(this.processor);
    }

    public void process(Exchange exchange) throws Exception {
        if (this.processor == null) {
            return;
        }
        if (!this.onComplete && !this.onFailure) {
            return;
        }
        exchange.getUnitOfWork().addSynchronization(new SynchronizationAdapter(){

            public void onComplete(Exchange exchange) {
                if (!OnCompletionProcessor.this.onComplete) {
                    return;
                }
                if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                    return;
                }
                final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
                OnCompletionProcessor.this.getExecutorService().submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Processing onComplete: " + copy));
                        }
                        OnCompletionProcessor.this.processor.process(copy);
                        return copy;
                    }
                });
            }

            public void onFailure(Exchange exchange) {
                if (!OnCompletionProcessor.this.onFailure) {
                    return;
                }
                if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                    return;
                }
                final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
                copy.setException(null);
                OnCompletionProcessor.this.getExecutorService().submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Processing onFailure: " + copy));
                        }
                        OnCompletionProcessor.this.processor.process(copy);
                        return copy;
                    }
                });
            }

            public String toString() {
                if (OnCompletionProcessor.this.onComplete && OnCompletionProcessor.this.onFailure) {
                    return "onCompleteOrFailure";
                }
                if (OnCompletionProcessor.this.onComplete) {
                    return "onCompleteOnly";
                }
                return "onFailureOnly";
            }
        });
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange copy = exchange.newCopy(false);
        copy.setPattern(ExchangePattern.InOnly);
        copy.setProperty("CamelOnCompletion", Boolean.TRUE);
        return copy;
    }

    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    private ExecutorService createExecutorService() {
        return ExecutorServiceHelper.newScheduledThreadPool(5, this.toString(), true);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String toString() {
        return "OnCompletionProcessor";
    }
}

