/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingSlip
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(RoutingSlip.class);
    private ProducerCache producerCache;
    private final String header;
    private final String uriDelimiter;

    public RoutingSlip(String header) {
        this(header, ",");
    }

    public RoutingSlip(String header, String uriDelimiter) {
        ObjectHelper.notNull(header, "header");
        ObjectHelper.notNull(uriDelimiter, "uriDelimiter");
        this.header = header;
        this.uriDelimiter = uriDelimiter;
    }

    public String toString() {
        return "RoutingSlip[header=" + this.header + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        String[] recipients = this.recipients(message);
        Exchange current = exchange;
        for (String nextRecipient : recipients) {
            Endpoint endpoint = this.resolveEndpoint(exchange, nextRecipient);
            Exchange copy = current.newInstance();
            this.updateRoutingSlip(current);
            this.copyOutToIn(copy, current);
            this.getProducerCache(exchange).doInProducer(endpoint, copy, null, new ProducerCallback<Object>(){

                @Override
                public Object doInProducer(Producer producer, Exchange exchange, ExchangePattern exchangePattern) throws Exception {
                    producer.process(exchange);
                    return exchange;
                }
            });
            current = copy;
        }
        ExchangeHelper.copyResults(exchange, current);
    }

    protected ProducerCache getProducerCache(Exchange exchange) throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(exchange.getContext().getProducerServicePool());
            this.producerCache.start();
        }
        return this.producerCache;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void doStart() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.stop();
        }
    }

    private void updateRoutingSlip(Exchange current) {
        Message message = this.getResultMessage(current);
        String oldSlip = message.getHeader(this.header, String.class);
        if (oldSlip != null) {
            int delimiterIndex = oldSlip.indexOf(this.uriDelimiter);
            String newSlip = delimiterIndex > 0 ? oldSlip.substring(delimiterIndex + 1) : "";
            message.setHeader(this.header, newSlip);
        }
    }

    private Message getResultMessage(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private String[] recipients(Message message) {
        Object headerValue = message.getHeader(this.header);
        if (headerValue != null && !headerValue.equals("")) {
            return headerValue.toString().split(this.uriDelimiter);
        }
        return new String[0];
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        if (source.hasFault()) {
            result.getFault().copyFrom(source.getFault());
        }
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }
}

