/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import org.apache.camel.Exchange;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdempotentOnCompletion
implements Synchronization {
    private static final transient Log LOG = LogFactory.getLog(IdempotentOnCompletion.class);
    private final IdempotentRepository idempotentRepository;
    private final String messageId;
    private final boolean eager;

    public IdempotentOnCompletion(IdempotentRepository idempotentRepository, String messageId, boolean eager) {
        this.idempotentRepository = idempotentRepository;
        this.messageId = messageId;
        this.eager = eager;
    }

    public void onComplete(Exchange exchange) {
        this.onCompletedMessage(exchange, this.messageId);
    }

    public void onFailure(Exchange exchange) {
        this.onFailedMessage(exchange, this.messageId);
    }

    protected void onCompletedMessage(Exchange exchange, String messageId) {
        if (!this.eager) {
            this.idempotentRepository.add(messageId);
        }
        this.idempotentRepository.confirm(messageId);
    }

    protected void onFailedMessage(Exchange exchange, String messageId) {
        this.idempotentRepository.remove(messageId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removed from repository as exchange failed: " + exchange + " with id: " + messageId));
        }
    }

    public String toString() {
        return "IdempotentOnCompletion[" + this.messageId + ']';
    }
}

