/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.interceptor.Breakpoint;
import org.apache.camel.processor.interceptor.ExceptionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugInterceptor
extends DelegateProcessor {
    private final ProcessorDefinition node;
    private final List<Exchange> exchanges;
    private final List<ExceptionEvent> exceptions;
    private Predicate traceFilter;
    private Breakpoint breakpoint = new Breakpoint();
    private boolean traceExceptions = true;
    private boolean enabled = true;

    public DebugInterceptor(ProcessorDefinition node, Processor target, List<Exchange> exchanges, List<ExceptionEvent> exceptions) {
        super(target);
        this.node = node;
        this.exchanges = exchanges;
        this.exceptions = exceptions;
    }

    @Override
    public String toString() {
        return "DebugInterceptor[" + this.node + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.isEnabled()) {
            this.checkForBreakpoint(exchange);
            this.addTraceExchange(exchange);
        }
        try {
            super.proceed(exchange);
        }
        catch (Exception e) {
            this.onException(exchange, e);
            throw e;
        }
        catch (Error e) {
            this.onException(exchange, e);
            throw e;
        }
    }

    public ProcessorDefinition getNode() {
        return this.node;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public List<Exchange> getExchanges() {
        return this.exchanges;
    }

    public List<ExceptionEvent> getExceptions() {
        return this.exceptions;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public Predicate getTraceFilter() {
        return this.traceFilter;
    }

    public void setTraceFilter(Predicate traceFilter) {
        this.traceFilter = traceFilter;
    }

    public boolean isTraceExceptions() {
        return this.traceExceptions;
    }

    public void setTraceExceptions(boolean traceExceptions) {
        this.traceExceptions = traceExceptions;
    }

    protected void checkForBreakpoint(Exchange exchange) {
        this.breakpoint.waitForBreakpoint(exchange);
    }

    protected void onException(Exchange exchange, Throwable e) {
        if (this.shouldTraceExceptionEvents(exchange, e)) {
            this.exceptions.add(new ExceptionEvent(this, exchange, e));
        }
    }

    private boolean shouldTraceExceptionEvents(Exchange exchange, Throwable e) {
        return this.isTraceExceptions() && this.isEnabled();
    }

    protected void addTraceExchange(Exchange exchange) {
        if (this.shouldTraceExchange(exchange)) {
            this.exchanges.add(this.copyExchange(exchange));
        }
    }

    protected Exchange copyExchange(Exchange previousExchange) {
        Exchange answer = previousExchange.newInstance();
        answer.getProperties().putAll(previousExchange.getProperties());
        answer.getIn().copyFrom(previousExchange.getIn());
        if (previousExchange.hasOut()) {
            answer.getOut().copyFrom(previousExchange.getOut());
        }
        return answer;
    }

    protected boolean shouldTraceExchange(Exchange exchange) {
        return this.traceFilter == null || this.traceFilter.matches(exchange);
    }
}

