/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;

public class HandleFaultInterceptor
extends DelegateProcessor {
    public HandleFaultInterceptor() {
    }

    public HandleFaultInterceptor(Processor processor) {
        this();
        this.setProcessor(processor);
    }

    public String toString() {
        return "HandleFaultInterceptor[" + this.processor + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (this.processor == null) {
            return;
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        this.handleFault(exchange);
    }

    protected void handleFault(Exchange exchange) {
        Object faultBody;
        if (exchange.hasFault() && (faultBody = exchange.getFault().getBody()) != null && exchange.getException() == null) {
            exchange.removeFault();
            if (faultBody instanceof Exception) {
                exchange.setException((Exception)faultBody);
            } else {
                exchange.setException(new CamelException(faultBody.toString()));
            }
        }
    }
}

