/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.List;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.osgi.OsgiAnnotationTypeConverterLoader;
import org.apache.camel.osgi.OsgiComponentResolver;
import org.apache.camel.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.osgi.OsgiLanguageResolver;
import org.apache.camel.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

public class CamelContextFactory
implements BundleContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelContextFactory.class);
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DefaultCamelContext createContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        if (this.bundleContext != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The bundle context is not be null, let's setup the Osgi resolvers");
            }
            context.setFactoryFinderResolver((FactoryFinderResolver)new OsgiFactoryFinderResolver());
            context.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(this.bundleContext));
            context.setComponentResolver((ComponentResolver)new OsgiComponentResolver());
            context.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver());
            this.addOsgiAnnotationTypeConverterLoader(context, this.bundleContext);
        }
        return context;
    }

    protected void addOsgiAnnotationTypeConverterLoader(DefaultCamelContext context, BundleContext bundleContext) {
        DefaultTypeConverter typeConverter = (DefaultTypeConverter)context.getTypeConverter();
        List typeConverterLoaders = typeConverter.getTypeConverterLoaders();
        TypeConverterLoader atLoader = null;
        for (TypeConverterLoader loader : typeConverterLoaders) {
            if (!(loader instanceof AnnotationTypeConverterLoader)) continue;
            atLoader = loader;
            break;
        }
        if (atLoader != null) {
            typeConverterLoaders.remove(atLoader);
        }
        typeConverterLoaders.add(new OsgiAnnotationTypeConverterLoader(context.getPackageScanClassResolver()));
        LOG.debug((Object)"added the OsgiAnnotationTypeConverterLoader");
    }
}

