/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.EventDrivenPollingConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultEndpoint
implements Endpoint,
CamelContextAware {
    private static final int DEFAULT_THREADPOOL_SIZE = 5;
    private String endpointUri;
    private CamelContext camelContext;
    private Component component;
    private ExecutorService executorService;
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;

    protected DefaultEndpoint(String endpointUri, Component component) {
        this(endpointUri, component.getCamelContext());
        this.component = component;
    }

    protected DefaultEndpoint(String endpointUri, CamelContext camelContext) {
        this(endpointUri);
        this.camelContext = camelContext;
    }

    protected DefaultEndpoint(String endpointUri) {
        this.setEndpointUri(endpointUri);
    }

    protected DefaultEndpoint() {
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)object;
            return ObjectHelper.equal(this.getEndpointUri(), that.getEndpointUri());
        }
        return false;
    }

    public String toString() {
        return "Endpoint[" + this.getEndpointUri() + "]";
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointUri == null) {
            this.endpointUri = this.createEndpointUri();
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is not specified and " + this.getClass().getName() + " does not implement createEndpointUri() to create a default value");
            }
        }
        return this.endpointUri;
    }

    @Override
    public String getEndpointKey() {
        if (this.isLenientProperties()) {
            String uri = this.getEndpointUri();
            if (uri.indexOf(63) != -1) {
                return ObjectHelper.before(uri, "?");
            }
            return uri;
        }
        return this.getEndpointUri();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Component c = this.getComponent();
            if (c instanceof DefaultComponent) {
                DefaultComponent dc = (DefaultComponent)c;
                this.executorService = dc.getExecutorService();
            }
            if (this.executorService == null) {
                this.executorService = this.createScheduledExecutorService();
            }
        }
        return this.executorService;
    }

    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        ExecutorService executor = this.getExecutorService();
        if (executor instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)executor;
        }
        return this.createScheduledExecutorService();
    }

    public synchronized void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        return new EventDrivenPollingConsumer(this);
    }

    public Exchange convertTo(Class<Exchange> type, Exchange exchange) {
        if (type.isInstance(exchange)) {
            return type.cast(exchange);
        }
        return this.getCamelContext().getExchangeConverter().convertTo(type, exchange);
    }

    @Override
    public Exchange createExchange(Exchange exchange) {
        Class<Exchange> exchangeType = this.getExchangeType();
        if (exchangeType != null && exchangeType.isInstance(exchange)) {
            return exchangeType.cast(exchange);
        }
        Exchange answer = this.createExchange();
        answer.copyFrom(exchange);
        return answer;
    }

    public Class<Exchange> getExchangeType() {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    @Override
    public Exchange createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return new DefaultExchange(this, pattern);
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    protected ScheduledExecutorService createScheduledExecutorService() {
        return ExecutorServiceHelper.newScheduledThreadPool(5, this.getEndpointUri(), true);
    }

    @Override
    public void configureProperties(Map options) {
    }

    protected String createEndpointUri() {
        return null;
    }

    public void setEndpointUriIfNotSpecified(String value) {
        if (this.endpointUri == null) {
            this.setEndpointUri(value);
        }
    }

    protected void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }
}

