/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.model.DescriptionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="optionalIdentifiedType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OptionalIdentifiedType<T extends OptionalIdentifiedType> {
    @XmlTransient
    protected static Map<String, AtomicInteger> nodeCounters = new HashMap<String, AtomicInteger>();
    @XmlAttribute(required=false)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    @XmlTransient
    private boolean customId;
    @XmlElement(required=false)
    private DescriptionDefinition description;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
        this.customId = true;
    }

    public DescriptionDefinition getDescription() {
        return this.description;
    }

    public void setDescription(DescriptionDefinition description) {
        this.description = description;
    }

    public String getShortName() {
        return "node";
    }

    public T description(String id, String text, String lang) {
        if (id != null) {
            this.setId(id);
        }
        if (text != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setText(text);
        }
        if (lang != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setLang(lang);
        }
        return (T)this;
    }

    public T id(String id) {
        this.setId(id);
        return (T)this;
    }

    public String idOrCreate() {
        if (this.id == null) {
            this.id = this.createId();
        }
        return this.getId();
    }

    public boolean hasCustomIdAssigned() {
        return this.customId;
    }

    protected String createId() {
        String key = this.getShortName();
        return key + OptionalIdentifiedType.getNodeCounter(key).incrementAndGet();
    }

    protected static synchronized AtomicInteger getNodeCounter(String key) {
        AtomicInteger answer = nodeCounters.get(key);
        if (answer == null) {
            answer = new AtomicInteger(0);
            nodeCounters.put(key, answer);
        }
        return answer;
    }
}

