/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

public class WireTapProcessor
extends SendProcessor {
    private ExecutorService executorService;
    private Expression newExchangeExpression;
    private Processor newExchangeProcessor;

    public WireTapProcessor(Endpoint destination) {
        super(destination);
    }

    public WireTapProcessor(Endpoint destination, ExchangePattern pattern) {
        super(destination, pattern);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        super.doStop();
    }

    public String toString() {
        return "WireTap[" + this.destination.getEndpointUri() + "]";
    }

    public void process(Exchange exchange) throws Exception {
        this.getProducerCache(exchange).doInProducer(this.destination, exchange, this.pattern, new ProducerCallback<Exchange>(){

            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                Exchange wireTapExchange = WireTapProcessor.this.configureExchange(exchange, pattern);
                WireTapProcessor.this.procesWireTap(producer, wireTapExchange);
                return wireTapExchange;
            }
        });
    }

    protected void procesWireTap(final Producer producer, final Exchange exchange) {
        this.getExecutorService().submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                if (SendProcessor.LOG.isDebugEnabled()) {
                    SendProcessor.LOG.debug((Object)("Processing wiretap: " + exchange));
                }
                producer.process(exchange);
                return exchange;
            }
        });
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        if (this.newExchangeProcessor == null && this.newExchangeExpression == null) {
            return this.configureCopyExchange(exchange);
        }
        return this.configureNewExchange(exchange);
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = exchange.copy(false);
        copy.setPattern(ExchangePattern.InOnly);
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        DefaultExchange answer = new DefaultExchange(exchange.getContext(), ExchangePattern.InOnly);
        answer.setFromEndpoint(this.getDestination());
        if (this.newExchangeProcessor != null) {
            try {
                this.newExchangeProcessor.process(answer);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        } else {
            Object body = this.newExchangeExpression.evaluate(answer, Object.class);
            if (body != null) {
                answer.getIn().setBody(body);
            }
        }
        return answer;
    }

    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    private ExecutorService createExecutorService() {
        return ExecutorServiceHelper.newScheduledThreadPool(5, this.toString(), true);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor newExchangeProcessor) {
        this.newExchangeProcessor = newExchangeProcessor;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }
}

