/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;

public class DefaultCxfRsBinding
implements CxfRsBinding,
HeaderFilterStrategyAware {
    private HeaderFilterStrategy headerFilterStrategy;

    public Object populateCxfRsResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        if (camelExchange.isFailed()) {
            throw camelExchange.getException();
        }
        return camelExchange.getOut().getBody();
    }

    public void populateExchangeFromCxfRsRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Method method, Object[] paramArray) {
        Message camelMessage = camelExchange.getIn();
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.REQUEST_URI, "CamelHttpUri");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.HTTP_REQUEST_METHOD, "CamelHttpMethod");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.PATH_INFO, "CamelHttpPath");
        this.copyMessageHeader(cxfMessage, camelMessage, "Content-Type", "Content-Type");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.ENCODING, "CamelHttpCharacterEncoding");
        this.copyMessageHeader(cxfMessage, camelMessage, org.apache.cxf.message.Message.QUERY_STRING, "CamelHttpQuery");
        this.copyMessageHeader(cxfMessage, camelMessage, "Accept", "CamelAcceptContentType");
        camelMessage.setHeader("CamelCxfRsResponseClass", method.getReturnType());
        this.copyOperationResourceInfoStack(cxfMessage, camelMessage);
        camelMessage.setHeader("operationName", (Object)method.getName());
        camelMessage.setHeader("CamelCxfRsMethod", (Object)method);
        camelMessage.setBody((Object)paramArray);
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected void copyMessageHeader(org.apache.cxf.message.Message cxfMessage, Message camelMessage, String cxfKey, String camelKey) {
        if (cxfMessage.get((Object)cxfKey) != null) {
            camelMessage.setHeader(camelKey, cxfMessage.get((Object)cxfKey));
        }
    }

    protected void copyOperationResourceInfoStack(org.apache.cxf.message.Message cxfMessage, Message camelMessage) {
        OperationResourceInfoStack stack = (OperationResourceInfoStack)cxfMessage.get(OperationResourceInfoStack.class);
        if (stack != null) {
            OperationResourceInfoStack copyStack = (OperationResourceInfoStack)stack.clone();
            camelMessage.setHeader("CamelCxfRsOperationResourceInfoStack", (Object)copyStack);
        }
    }
}

