/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessage
extends DefaultMessage {
    private static final transient Log LOG = LogFactory.getLog(JmsMessage.class);
    private javax.jms.Message jmsMessage;
    private JmsBinding binding;

    public JmsMessage() {
    }

    public JmsMessage(javax.jms.Message jmsMessage) {
        this.setJmsMessage(jmsMessage);
    }

    public JmsMessage(javax.jms.Message jmsMessage, JmsBinding binding) {
        this(jmsMessage);
        this.setBinding(binding);
    }

    public String toString() {
        if (this.jmsMessage != null) {
            return "JmsMessage: " + this.jmsMessage;
        }
        return "JmsMessage: " + this.getBody();
    }

    public void copyFrom(Message that) {
        boolean copyMessageId = true;
        if (that instanceof JmsMessage) {
            JmsMessage thatMessage = (JmsMessage)that;
            this.jmsMessage = thatMessage.jmsMessage;
            if (this.jmsMessage != null) {
                copyMessageId = false;
            }
        }
        if (copyMessageId) {
            this.setMessageId(that.getMessageId());
        }
        this.setBody(that.getBody());
        this.getHeaders().putAll(that.getHeaders());
        this.getAttachments().putAll(that.getAttachments());
    }

    public javax.jms.Message getJmsMessage() {
        return this.jmsMessage;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            JmsBinding b = (JmsBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), JmsBinding.class);
            return b != null ? b : new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public void setJmsMessage(javax.jms.Message jmsMessage) {
        try {
            this.setMessageId(jmsMessage.getJMSMessageID());
        }
        catch (JMSException e) {
            LOG.warn((Object)"Unable to retrieve JMSMessageID from JMS Message", (Throwable)e);
        }
        this.jmsMessage = jmsMessage;
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.jmsMessage != null && !name.startsWith("JMS")) {
            try {
                answer = this.jmsMessage.getObjectProperty(name);
            }
            catch (JMSException e) {
                throw new RuntimeCamelException(name, (Throwable)e);
            }
        }
        if (answer == null) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public Object removeHeader(String name) {
        Object answer = super.removeHeader(name);
        if (this.jmsMessage != null && !name.startsWith("JMS")) {
            try {
                if (this.jmsMessage.propertyExists(name)) {
                    answer = JmsMessageHelper.removeJmsProperty(this.jmsMessage, name);
                }
            }
            catch (JMSException e) {
                throw new RuntimeCamelException(name, (Throwable)e);
            }
        }
        return answer;
    }

    public JmsMessage newInstance() {
        return new JmsMessage();
    }

    public boolean shouldCreateNewMessage() {
        return super.hasPopulatedHeaders();
    }

    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null && map != null) {
            map.putAll(this.getBinding().extractHeadersFromJms(this.jmsMessage, this.getExchange()));
        }
    }

    protected String createMessageId() {
        if (this.jmsMessage == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"No javax.jms.Message set so generating a new message id");
            }
            return super.createMessageId();
        }
        try {
            String id = this.getDestinationAsString(this.jmsMessage.getJMSDestination()) + this.jmsMessage.getJMSMessageID();
            return this.getSanitizedString(id);
        }
        catch (JMSException e) {
            throw new RuntimeCamelException("Failed to get JMSMessageID property", (Throwable)e);
        }
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = destination == null ? "null destination!" + File.separator : (destination instanceof Topic ? "topic" + File.separator + ((Topic)destination).getTopicName() + File.separator : "queue" + File.separator + ((Queue)destination).getQueueName() + File.separator);
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }

    public String createExchangeId() {
        if (this.jmsMessage != null) {
            try {
                return this.jmsMessage.getJMSMessageID();
            }
            catch (JMSException e) {
                throw new RuntimeCamelException("Failed to get JMSMessageID property", (Throwable)e);
            }
        }
        return super.createExchangeId();
    }
}

