/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericFileEndpoint<T>
extends ScheduledPollEndpoint {
    protected static final transient String DEFAULT_STRATEGYFACTORY_CLASS = "org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory";
    protected static final transient int DEFAULT_IDEMPOTENT_CACHE_SIZE = 1000;
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected GenericFileProcessStrategy<T> processStrategy;
    protected GenericFileConfiguration configuration;
    protected IdempotentRepository<String> inProgressRepository = new MemoryIdempotentRepository();
    protected String localWorkDirectory;
    protected boolean autoCreate = true;
    protected int bufferSize = 131072;
    protected GenericFileExist fileExist = GenericFileExist.Override;
    protected boolean noop;
    protected boolean recursive;
    protected boolean delete;
    protected boolean flatten;
    protected int maxMessagesPerPoll;
    protected String tempPrefix;
    protected String include;
    protected String exclude;
    protected Expression fileName;
    protected Expression move;
    protected Expression preMove;
    protected boolean idempotent;
    protected IdempotentRepository idempotentRepository;
    protected GenericFileFilter<T> filter;
    protected Comparator<GenericFile<T>> sorter;
    protected Comparator<Exchange> sortBy;
    protected String readLock = "none";
    protected long readLockTimeout;
    protected GenericFileExclusiveReadLockStrategy exclusiveReadLockStrategy;

    public GenericFileEndpoint() {
    }

    public GenericFileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public abstract GenericFileConsumer<T> createConsumer(Processor var1) throws Exception;

    @Override
    public abstract GenericFileProducer<T> createProducer() throws Exception;

    public abstract Exchange createExchange(GenericFile<T> var1);

    public abstract String getScheme();

    public abstract char getFileSeparator();

    public abstract boolean isAbsolute(String var1);

    public String getGeneratedFileName(Message message) {
        return UuidGenerator.generateSanitizedId(message.getMessageId());
    }

    public GenericFileProcessStrategy<T> getGenericFileProcessStrategy() {
        if (this.processStrategy == null) {
            this.processStrategy = this.createGenericFileStrategy();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using Generic file process strategy: " + this.processStrategy));
            }
        }
        return this.processStrategy;
    }

    protected GenericFileProcessStrategy<T> createGenericFileStrategy() {
        Class factory = null;
        try {
            FactoryFinder finder = this.getCamelContext().getFactoryFinder("META-INF/services/org/apache/camel/component/");
            factory = finder.findClass(this.getScheme(), "strategy.factory.");
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)"'strategy.factory.class' not found", (Throwable)e);
        }
        catch (IOException e) {
            this.log.debug((Object)"No strategy factory defined in 'META-INF/services/org/apache/camel/component/'", (Throwable)e);
        }
        if (factory == null && (factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS)) == null) {
            throw new TypeNotPresentException("org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory class not found", null);
        }
        try {
            Method factoryMethod = factory.getMethod("createGenericFileProcessStrategy", CamelContext.class, Map.class);
            return (GenericFileProcessStrategy)ObjectHelper.invokeMethod(factoryMethod, null, this.getCamelContext(), this.getParamsAsMap());
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(factory.getSimpleName() + ".createGenericFileProcessStrategy method not found", e);
        }
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public Expression getMove() {
        return this.move;
    }

    public void setMove(Expression move) {
        this.move = move;
    }

    public void setMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.move = this.createFileLangugeExpression(expression);
    }

    public Expression getPreMove() {
        return this.preMove;
    }

    public void setPreMove(Expression preMove) {
        this.preMove = preMove;
    }

    public void setPreMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.preMove = this.createFileLangugeExpression(expression);
    }

    public Expression getFileName() {
        return this.fileName;
    }

    public void setFileName(Expression fileName) {
        this.fileName = fileName;
    }

    public void setFileName(String fileLanguageExpression) {
        this.fileName = this.createFileLangugeExpression(fileLanguageExpression);
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public void setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public GenericFileFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(GenericFileFilter<T> filter) {
        this.filter = filter;
    }

    public Comparator<GenericFile<T>> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<GenericFile<T>> sorter) {
        this.sorter = sorter;
    }

    public Comparator<Exchange> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Comparator<Exchange> sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortBy(String expression) {
        this.setSortBy(expression, false);
    }

    public void setSortBy(String expression, boolean reverse) {
        this.setSortBy(GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), expression, reverse));
    }

    public String getTempPrefix() {
        return this.tempPrefix;
    }

    public void setTempPrefix(String tempPrefix) {
        this.tempPrefix = tempPrefix;
    }

    public GenericFileConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GenericFileConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericFileExclusiveReadLockStrategy getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    public String getReadLock() {
        return this.readLock;
    }

    public void setReadLock(String readLock) {
        this.readLock = readLock;
    }

    public long getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(long readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public GenericFileExist getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(GenericFileExist fileExist) {
        this.fileExist = fileExist;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public GenericFileProcessStrategy<T> getProcessStrategy() {
        return this.processStrategy;
    }

    public void setProcessStrategy(GenericFileProcessStrategy<T> processStrategy) {
        this.processStrategy = processStrategy;
    }

    public String getLocalWorkDirectory() {
        return this.localWorkDirectory;
    }

    public void setLocalWorkDirectory(String localWorkDirectory) {
        this.localWorkDirectory = localWorkDirectory;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public IdempotentRepository<String> getInProgressRepository() {
        return this.inProgressRepository;
    }

    public void setInProgressRepository(IdempotentRepository<String> inProgressRepository) {
        this.inProgressRepository = inProgressRepository;
    }

    public void configureMessage(GenericFile<T> file, Message message) {
        message.setBody(file);
        if (this.flatten) {
            message.setHeader("CamelFileName", file.getFileNameOnly());
        } else {
            String name = file.isAbsolute() ? file.getAbsoluteFilePath() : file.getRelativeFilePath();
            String endpointPath = this.getConfiguration().getDirectory();
            if (ObjectHelper.isNotEmpty(endpointPath) && name.startsWith(endpointPath)) {
                name = ObjectHelper.after(name, this.getConfiguration().getDirectory() + File.separator);
            }
            message.setHeader("CamelFileName", name);
        }
    }

    protected String configureMoveOrPreMoveExpression(String expression) {
        if (expression.indexOf("${") != -1) {
            return expression;
        }
        expression = FileUtil.stripTrailingSeparator(expression);
        StringBuilder sb = new StringBuilder();
        if (!this.isAbsolute(expression)) {
            sb.append("${file:parent}");
            sb.append(this.getFileSeparator());
        }
        sb.append(expression);
        sb.append(this.getFileSeparator());
        sb.append("${file:onlyname}");
        return sb.toString();
    }

    protected Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.isNoop()) {
            params.put("noop", Boolean.toString(true));
        }
        if (this.isDelete()) {
            params.put("delete", Boolean.toString(true));
        }
        if (this.move != null) {
            params.put("move", this.move);
        }
        if (this.preMove != null) {
            params.put("preMove", this.preMove);
        }
        if (this.exclusiveReadLockStrategy != null) {
            params.put("exclusiveReadLockStrategy", this.exclusiveReadLockStrategy);
        }
        if (this.readLock != null) {
            params.put("readLock", this.readLock);
        }
        if (this.readLockTimeout > 0L) {
            params.put("readLockTimeout", this.readLockTimeout);
        }
        return params;
    }

    private Expression createFileLangugeExpression(String expression) {
        Language language = this.getCamelContext().resolveLanguage("file");
        return language.createExpression(expression);
    }
}

