/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.spring.CxfEndpointBeanDefinitionParser;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.MessageContentsList;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converter
public final class CxfConverter {
    private static final Log LOG = LogFactory.getLog(CxfConverter.class);

    private CxfConverter() {
    }

    @Converter
    public static MessageContentsList toMessageContentsList(Object[] array) {
        if (array != null) {
            return new MessageContentsList(array);
        }
        return new MessageContentsList();
    }

    @Converter
    public static List<Class> toClassesList(String[] classNames) throws ClassNotFoundException {
        ArrayList<Class> answer = new ArrayList<Class>();
        for (String className : classNames) {
            answer.add(ClassLoaderUtils.loadClass((String)className.trim(), CxfConverter.class));
        }
        return answer;
    }

    @Converter
    public static List<Class> toClassList(String classeString) throws ClassNotFoundException {
        String[] classNames = classeString.split(",|;");
        return CxfConverter.toClassesList(classNames);
    }

    @Converter
    public static Object[] toArray(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).toArray();
        }
        Object[] answer = object == null ? new Object[]{} : new Object[]{object};
        return answer;
    }

    @Converter
    public static String soapMessageToString(SOAPMessage soapMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            soapMessage.writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            LOG.error((Object)("Get the exception when converting the SOAPMessage into String, the exception is " + e));
        }
        return baos.toString();
    }

    @Converter
    public static Endpoint toEndpoint(CxfEndpointBeanDefinitionParser.CxfSpringEndpointBean endpointBean) throws Exception {
        if (endpointBean == null) {
            throw new IllegalArgumentException("The CxfEndpoint instance is null");
        }
        SpringCamelContext context = SpringCamelContext.springCamelContext((ApplicationContext)endpointBean.getApplicationContext());
        CxfSpringEndpoint answer = new CxfSpringEndpoint((CamelContext)context, (CxfEndpointBean)endpointBean);
        return answer;
    }

    @Converter
    public static DataFormat toDataFormat(String name) {
        return DataFormat.valueOf(name.toUpperCase());
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (MessageContentsList.class.isAssignableFrom(value.getClass())) {
            MessageContentsList list = (MessageContentsList)value;
            for (Object embedded : list) {
                if (embedded == null) continue;
                if (type.isInstance(embedded)) {
                    return type.cast(embedded);
                }
                TypeConverter tc = registry.lookup(type, embedded.getClass());
                if (tc == null) continue;
                return (T)tc.convertTo(type, exchange, embedded);
            }
        }
        return null;
    }
}

