/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiServiceRegistry
implements Registry {
    private BundleContext bundleContext;
    private Map<String, Object> serviceCacheMap = new ConcurrentHashMap<String, Object>();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    public <T> T lookup(String name, Class<T> type) {
        Object service = this.lookup(name);
        return type.cast(service);
    }

    public Object lookup(String name) {
        ServiceReference sr;
        Object service = this.serviceCacheMap.get(name);
        if (service == null && (sr = this.bundleContext.getServiceReference(name)) != null && (service = this.bundleContext.getService(sr)) != null) {
            this.serviceCacheMap.put(name, service);
        }
        return service;
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return Collections.EMPTY_MAP;
    }
}

