/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.Message;

public abstract class AbstractDeadLetterStrategy
implements DeadLetterStrategy {
    private boolean processNonPersistent = false;
    private boolean processExpired = true;

    public boolean isSendToDeadLetterQueue(Message message) {
        boolean result = false;
        if (message != null) {
            result = true;
            if (!message.isPersistent() && !this.processNonPersistent) {
                result = false;
            }
            if (message.isExpired() && !this.processExpired) {
                result = false;
            }
        }
        return result;
    }

    public boolean isProcessExpired() {
        return this.processExpired;
    }

    public void setProcessExpired(boolean processExpired) {
        this.processExpired = processExpired;
    }

    public boolean isProcessNonPersistent() {
        return this.processNonPersistent;
    }

    public void setProcessNonPersistent(boolean processNonPersistent) {
        this.processNonPersistent = processNonPersistent;
    }
}

