/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.util.LazyList;
import org.mortbay.xml.XmlConfiguration;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.internal.JettyServer;
import org.ops4j.pax.web.service.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.internal.model.ErrorPageModel;
import org.ops4j.pax.web.service.internal.model.EventListenerModel;
import org.ops4j.pax.web.service.internal.model.FilterModel;
import org.ops4j.pax.web.service.internal.model.ServerModel;
import org.ops4j.pax.web.service.internal.model.ServletModel;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JettyServerImpl
implements JettyServer {
    private static final Log LOG = LogFactory.getLog(JettyServerImpl.class);
    private final JettyServerWrapper m_server;

    JettyServerImpl(ServerModel serverModel) {
        this.m_server = new JettyServerWrapper(serverModel);
    }

    @Override
    public void start() {
        LOG.info("starting " + this);
        try {
            URL resource = this.getClass().getResource("/jetty.xml");
            if (resource != null) {
                LOG.info("configure using " + resource);
                XmlConfiguration configuration = new XmlConfiguration(resource);
                configuration.configure((Object)this.m_server);
            }
            this.m_server.start();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public void stop() {
        LOG.info("stopping " + this);
        try {
            this.m_server.stop();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public void addConnector(Connector connector) {
        LOG.info("adding connector" + connector);
        this.m_server.addConnector(connector);
    }

    @Override
    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout) {
        this.m_server.configureContext(attributes, sessionTimeout);
    }

    @Override
    public void addServlet(ServletModel model) {
        LOG.debug("Adding servlet [" + model + "]");
        final ServletMapping mapping = new ServletMapping();
        mapping.setServletName(model.getName());
        mapping.setPathSpecs(model.getUrlPatterns());
        Context context = this.m_server.getOrCreateContext(model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final ServletHolder holder = new ServletHolder(model.getServlet());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addServlet(holder);
                    servletHandler.addServletMapping(mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during servlet registration", e);
        }
    }

    @Override
    public void removeServlet(ServletModel model) {
        ServletHolder holder;
        LOG.debug("Removing servlet [" + model + "]");
        boolean removed = false;
        Context context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ServletHandler servletHandler = context.getServletHandler();
        Object[] holders = servletHandler.getServlets();
        if (holders != null && (holder = servletHandler.getServlet(model.getName())) != null) {
            servletHandler.setServlets((ServletHolder[])LazyList.removeFromArray((Object[])holders, (Object)holder));
            Object[] mappings = servletHandler.getServletMappings();
            if (mappings != null) {
                ServletMapping mapping = null;
                for (ServletMapping servletMapping : mappings) {
                    if (!holder.getName().equals(servletMapping.getServletName())) continue;
                    mapping = servletMapping;
                    break;
                }
                if (mapping != null) {
                    servletHandler.setServletMappings((ServletMapping[])LazyList.removeFromArray((Object[])mappings, mapping));
                    removed = true;
                }
            }
            if (holder.isStarted()) {
                try {
                    ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            holder.stop();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    LOG.warn("Exception during unregistering of servlet [" + model + "]");
                }
            }
        }
        if (!removed) {
            throw new IllegalStateException(model + " was not found");
        }
    }

    @Override
    public void addEventListener(EventListenerModel model) {
        this.m_server.getOrCreateContext(model).addEventListener(model.getEventListener());
    }

    @Override
    public void removeEventListener(EventListenerModel model) {
        Context context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ArrayList<EventListener> listeners = new ArrayList<EventListener>(Arrays.asList(context.getEventListeners()));
        listeners.remove(model.getEventListener());
        context.setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        this.m_server.removeContext(httpContext);
    }

    @Override
    public void addFilter(FilterModel model) {
        Context context;
        ServletHandler servletHandler;
        LOG.debug("Adding filter model [" + model + "]");
        final FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(model.getName());
        if (model.getUrlPatterns() != null && model.getUrlPatterns().length > 0) {
            mapping.setPathSpecs(model.getUrlPatterns());
        }
        if (model.getServletNames() != null && model.getServletNames().length > 0) {
            mapping.setServletNames(model.getServletNames());
        }
        if ((servletHandler = (context = this.m_server.getOrCreateContext(model)).getServletHandler()) == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final FilterHolder holder = new FilterHolder(model.getFilter());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addFilter(holder, mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during filter registration", e);
        }
    }

    @Override
    public void removeFilter(FilterModel model) {
        LOG.debug("Removing filter model [" + model + "]");
        Context context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ServletHandler servletHandler = context.getServletHandler();
        Object[] filterMappings = servletHandler.getFilterMappings();
        Object[] newFilterMappings = null;
        for (FilterMapping filterMapping : filterMappings) {
            if (!filterMapping.getFilterName().equals(model.getName())) continue;
            if (newFilterMappings == null) {
                newFilterMappings = filterMappings;
            }
            newFilterMappings = (FilterMapping[])LazyList.removeFromArray((Object[])newFilterMappings, (Object)filterMapping);
        }
        servletHandler.setFilterMappings(newFilterMappings);
        final FilterHolder filterHolder = servletHandler.getFilter(model.getName());
        Object[] filterHolders = servletHandler.getFilters();
        FilterHolder[] newFilterHolders = (FilterHolder[])LazyList.removeFromArray((Object[])filterHolders, (Object)filterHolder);
        servletHandler.setFilters(newFilterHolders);
        if (filterHolder.isStarted()) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        filterHolder.stop();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                LOG.warn("Exception during unregistering of filter [" + filterHolder.getFilter() + "]");
            }
        }
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        Context context = this.m_server.getOrCreateContext(model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        HashMap<String, String> errorPages = errorPageHandler.getErrorPages();
        if (errorPages == null) {
            errorPages = new HashMap<String, String>();
        }
        errorPages.put(model.getError(), model.getLocation());
        errorPageHandler.setErrorPages(errorPages);
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        Context context = this.m_server.getOrCreateContext(model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        Map errorPages = errorPageHandler.getErrorPages();
        if (errorPages != null) {
            errorPages.remove(model.getError());
            if (errorPages.size() == 0) {
                errorPageHandler.setErrorPages(null);
            }
        }
    }

    public String toString() {
        return JettyServerImpl.class.getSimpleName() + "{" + "}";
    }
}

