/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCxfBinding
implements CxfBinding,
HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(DefaultCxfBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateCxfRequestFromExchange(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Map<String, Object> requestContext) {
        Map camelHeaders = camelExchange.getIn().getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, requestContext, "RequestContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, requestContext);
    }

    @Override
    public void populateExchangeFromCxfResponse(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> responseContext) {
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Populate exchange from CXF response message: " + cxfMessage));
        }
        camelExchange.getOut().setBody(DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class))));
        if (responseContext != null && responseContext.size() > 0) {
            camelExchange.getOut().setHeader("ResponseContext", responseContext);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Set header = ResponseContext value = " + responseContext));
            }
        }
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getOut(), camelExchange);
    }

    @Override
    public void populateExchangeFromCxfRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
        Object body;
        Method method = null;
        QName operationName = null;
        ExchangePattern mep = ExchangePattern.InOut;
        BindingOperationInfo boi = (BindingOperationInfo)camelExchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        if (boi != null) {
            MethodDispatcher md;
            Service service = (Service)cxfExchange.get(Service.class);
            if (service != null && (md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName())) != null) {
                method = md.getMethod(boi);
            }
            if (boi.getOperationInfo().isOneWay()) {
                mep = ExchangePattern.InOnly;
            }
            operationName = boi.getName();
        }
        if (operationName != null) {
            camelExchange.getIn().setHeader("operationNameSpace", (Object)boi.getName().getNamespaceURI());
            camelExchange.getIn().setHeader("operationName", (Object)boi.getName().getLocalPart());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Set IN header: operationNameSpace=" + boi.getName().getNamespaceURI()));
                LOG.trace((Object)("Set IN header: operationName=" + boi.getName().getLocalPart()));
            }
        } else if (method != null) {
            camelExchange.getIn().setHeader("operationName", (Object)method.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Set IN header: operationName=" + method.getName()));
            }
        }
        camelExchange.setPattern(mep);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set exchange MEP: " + mep));
        }
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getIn(), camelExchange);
        Object value = cxfMessage.get((Object)"RequestContext");
        if (value != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("RequestContext", value, camelExchange)) {
            camelExchange.getIn().setHeader("RequestContext", value);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Populate context from CXF message RequestContext value=" + value));
            }
        }
        if ((body = DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class)))) != null) {
            camelExchange.getIn().setBody(body);
        }
    }

    @Override
    public void populateCxfResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) {
        BindingOperationInfo boi;
        Object outBody;
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        Map camelHeaders = camelExchange.getOut().getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, responseContext, "ResponseContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, responseContext);
        Endpoint ep = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = ep.getBinding().createMessage();
        cxfExchange.setOutMessage(outMessage);
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        if (dataFormat != DataFormat.POJO) {
            outMessage.putAll(responseContext);
        }
        outMessage.put((Object)"ResponseContext", responseContext);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set out response context = " + responseContext));
        }
        if ((outBody = DefaultCxfBinding.getBodyFromCamel(camelExchange.getOut(), dataFormat)) != null) {
            if (dataFormat == DataFormat.PAYLOAD) {
                CxfPayload payload = (CxfPayload)outBody;
                outMessage.put(List.class, payload.getBody());
                outMessage.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                if (responseContext.get(Header.HEADER_LIST) != null) {
                    outMessage.put((Object)Header.HEADER_LIST, responseContext.get(Header.HEADER_LIST));
                }
                MessageContentsList resList = null;
                resList = outBody instanceof MessageContentsList ? (MessageContentsList)outBody : (outBody instanceof List ? new MessageContentsList((List)outBody) : (outBody.getClass().isArray() ? new MessageContentsList((Object[])outBody) : new MessageContentsList(new Object[]{outBody})));
                if (resList != null) {
                    outMessage.setContent(List.class, (Object)resList);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Set Out CXF message content = " + resList));
                    }
                }
            }
        }
        if ((boi = (BindingOperationInfo)cxfExchange.get(BindingOperationInfo.class)) != null) {
            cxfExchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected void extractInvocationContextFromCamel(Exchange camelExchange, Map<String, Object> camelHeaders, Map<String, Object> cxfContext, String contextKey) {
        Map context = (Map)camelHeaders.get(contextKey);
        if (context != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Propagate " + contextKey + " from header context = " + (context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context)));
            }
        }
        if ((context = (Map)camelExchange.getProperty(contextKey)) != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Propagate " + contextKey + " from exchange property context = " + (context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context)));
            }
        }
        if (camelExchange.getProperties() != null) {
            cxfContext.putAll(camelExchange.getProperties());
        }
        camelExchange.setProperty(contextKey, cxfContext);
    }

    protected void propagateHeadersFromCxfToCamel(org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        String key;
        Object value;
        Map cxfHeaders = (Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        Map camelHeaders = camelMessage.getHeaders();
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                camelHeaders.put(entry.getKey(), ((List)entry.getValue()).get(0));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Populate header from CXF header=" + (String)entry.getKey() + " value=" + entry.getValue()));
            }
        }
        if ((value = cxfMessage.get((Object)(key = Header.HEADER_LIST))) != null) {
            if (!this.headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) {
                camelHeaders.put(key, value);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Populate header from CXF header=" + key + " value=" + value));
                }
            } else {
                ((List)value).clear();
            }
        }
    }

    protected void propagateHeadersFromCamelToCxf(Exchange camelExchange, Map<String, Object> camelHeaders, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> cxfContext) {
        Map headers;
        Map h;
        HashMap<String, List> transportHeaders = new HashMap<String, List>();
        if (camelExchange != null && (h = (Map)camelExchange.getProperty(org.apache.cxf.message.Message.PROTOCOL_HEADERS)) != null) {
            transportHeaders.putAll(h);
        }
        if ((headers = (Map)camelHeaders.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS)) != null) {
            transportHeaders.putAll(headers);
        }
        for (Map.Entry<String, Object> entry : camelHeaders.entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), camelExchange)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Propagate to CXF header: " + entry.getKey() + " value: " + entry.getValue()));
            }
            if (org.apache.cxf.message.Message.RESPONSE_CODE.equals(entry.getKey())) {
                cxfContext.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (Header.HEADER_LIST.equals(entry.getKey())) {
                List headerList = (List)entry.getValue();
                for (Header header : headerList) {
                    header.setDirection(Header.Direction.DIRECTION_OUT);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Propagate SOAP/protocol header: " + header.getName() + " : " + header.getObject()));
                }
                cxfContext.put(entry.getKey(), headerList);
                continue;
            }
            if (entry.getValue() instanceof List) {
                transportHeaders.put(entry.getKey(), (List)entry.getValue());
                continue;
            }
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(entry.getValue().toString());
            transportHeaders.put(entry.getKey(), listValue);
        }
        if (transportHeaders.size() > 0) {
            cxfContext.put(org.apache.cxf.message.Message.PROTOCOL_HEADERS, transportHeaders);
        }
    }

    protected static Object getContentFromCxf(org.apache.cxf.message.Message message, DataFormat dataFormat) {
        Set contentFormats = message.getContentFormats();
        MessageContentsList answer = null;
        if (contentFormats != null) {
            if (LOG.isTraceEnabled()) {
                for (Class contentFormat : contentFormats) {
                    LOG.trace((Object)("Content format=" + contentFormat + " value=" + message.getContent(contentFormat)));
                }
            }
            if (dataFormat == DataFormat.POJO) {
                answer = message.getContent(List.class);
                if (answer == null && (answer = message.getContent(Object.class)) != null) {
                    answer = new MessageContentsList(new Object[]{answer});
                }
            } else if (dataFormat == DataFormat.PAYLOAD) {
                List body = (List)message.get(List.class);
                List headers = CastUtils.cast((List)((List)message.get((Object)Header.HEADER_LIST)));
                answer = new CxfPayload(headers, body);
            } else if (dataFormat == DataFormat.MESSAGE) {
                answer = message.getContent(InputStream.class);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Extracted body from CXF message = " + answer));
            }
        }
        return answer;
    }

    public static Object getBodyFromCamel(Message out, DataFormat dataFormat) {
        Object answer = null;
        if (dataFormat == DataFormat.POJO) {
            answer = out.getBody();
        } else if (dataFormat == DataFormat.PAYLOAD) {
            answer = out.getBody();
        } else if (dataFormat == DataFormat.MESSAGE) {
            answer = out.getBody(InputStream.class);
        }
        return answer;
    }
}

