/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.ExchangeConverter;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.spi.TypeConverterRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CamelContext
extends Service {
    public String getName();

    public void addComponent(String var1, Component var2);

    public Component getComponent(String var1);

    public <T extends Component> T getComponent(String var1, Class<T> var2);

    public List<String> getComponentNames();

    public Component removeComponent(String var1);

    public Component getOrCreateComponent(String var1, Callable<Component> var2);

    public Endpoint getEndpoint(String var1);

    public <T extends Endpoint> T getEndpoint(String var1, Class<T> var2);

    public Collection<Endpoint> getEndpoints();

    public Map<String, Endpoint> getEndpointMap();

    public Collection<Endpoint> getEndpoints(String var1);

    public Collection<Endpoint> getSingletonEndpoints();

    public Endpoint addEndpoint(String var1, Endpoint var2) throws Exception;

    public Collection<Endpoint> removeEndpoints(String var1) throws Exception;

    public void addRegisterEndpointCallback(EndpointStrategy var1);

    public List<RouteDefinition> getRouteDefinitions();

    public List<Route> getRoutes();

    public void addRoutes(RoutesBuilder var1) throws Exception;

    public void addRouteDefinitions(Collection<RouteDefinition> var1) throws Exception;

    public void removeRouteDefinitions(Collection<RouteDefinition> var1) throws Exception;

    public void startRoute(RouteDefinition var1) throws Exception;

    public void stopRoute(RouteDefinition var1) throws Exception;

    public ExchangeConverter getExchangeConverter();

    public TypeConverter getTypeConverter();

    public TypeConverterRegistry getTypeConverterRegistry();

    public Registry getRegistry();

    public Injector getInjector();

    public LifecycleStrategy getLifecycleStrategy();

    public Language resolveLanguage(String var1);

    public List<String> getLanguageNames();

    public ProducerTemplate createProducerTemplate();

    public ConsumerTemplate createConsumerTemplate();

    public void addInterceptStrategy(InterceptStrategy var1);

    public List<InterceptStrategy> getInterceptStrategies();

    public ErrorHandlerBuilder getErrorHandlerBuilder();

    public void setErrorHandlerBuilder(ErrorHandlerBuilder var1);

    public void setDataFormats(Map<String, DataFormatDefinition> var1);

    public Map<String, DataFormatDefinition> getDataFormats();

    public void setProperties(Map<String, String> var1);

    public Map<String, String> getProperties();

    public FactoryFinder getDefaultFactoryFinder();

    public void setFactoryFinderResolver(FactoryFinderResolver var1);

    public FactoryFinder getFactoryFinder(String var1) throws NoFactoryAvailableException;

    public ServiceStatus getRouteStatus(RouteDefinition var1);

    public ClassResolver getClassResolver();

    public PackageScanClassResolver getPackageScanClassResolver();

    public void setClassResolver(ClassResolver var1);

    public void setPackageScanClassResolver(PackageScanClassResolver var1);

    public void setProducerServicePool(ServicePool<Endpoint, Producer> var1);

    public ServicePool<Endpoint, Producer> getProducerServicePool();

    public void setStreamCaching(Boolean var1);

    public void setTracing(Boolean var1);
}

